/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeIpv6PoolsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeIpv6PoolsRequestMarshaller
implements Marshaller<Request<DescribeIpv6PoolsRequest>, DescribeIpv6PoolsRequest> {
    public Request<DescribeIpv6PoolsRequest> marshall(DescribeIpv6PoolsRequest describeIpv6PoolsRequest) {
        SdkInternalList describeIpv6PoolsRequestFiltersList;
        if (describeIpv6PoolsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeIpv6PoolsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeIpv6Pools");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeIpv6PoolsRequestPoolIdsList = (SdkInternalList)describeIpv6PoolsRequest.getPoolIds();
        if (!describeIpv6PoolsRequestPoolIdsList.isEmpty() || !describeIpv6PoolsRequestPoolIdsList.isAutoConstruct()) {
            int poolIdsListIndex = 1;
            for (String describeIpv6PoolsRequestPoolIdsListValue : describeIpv6PoolsRequestPoolIdsList) {
                if (describeIpv6PoolsRequestPoolIdsListValue != null) {
                    request.addParameter("PoolId." + poolIdsListIndex, StringUtils.fromString((String)describeIpv6PoolsRequestPoolIdsListValue));
                }
                ++poolIdsListIndex;
            }
        }
        if (describeIpv6PoolsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeIpv6PoolsRequest.getNextToken()));
        }
        if (describeIpv6PoolsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeIpv6PoolsRequest.getMaxResults()));
        }
        if (!(describeIpv6PoolsRequestFiltersList = (SdkInternalList)describeIpv6PoolsRequest.getFilters()).isEmpty() || !describeIpv6PoolsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeIpv6PoolsRequestFiltersListValue : describeIpv6PoolsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeIpv6PoolsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeIpv6PoolsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeIpv6PoolsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

