/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ModifyVerifiedAccessTrustProviderDeviceOptions;
import com.amazonaws.services.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions;
import com.amazonaws.services.ec2.model.ModifyVerifiedAccessTrustProviderRequest;
import com.amazonaws.services.ec2.model.VerifiedAccessSseSpecificationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class ModifyVerifiedAccessTrustProviderRequestMarshaller
implements Marshaller<Request<ModifyVerifiedAccessTrustProviderRequest>, ModifyVerifiedAccessTrustProviderRequest> {
    public Request<ModifyVerifiedAccessTrustProviderRequest> marshall(ModifyVerifiedAccessTrustProviderRequest modifyVerifiedAccessTrustProviderRequest) {
        ModifyVerifiedAccessTrustProviderDeviceOptions deviceOptions;
        ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions;
        if (modifyVerifiedAccessTrustProviderRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVerifiedAccessTrustProviderRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVerifiedAccessTrustProvider");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVerifiedAccessTrustProviderRequest.getVerifiedAccessTrustProviderId() != null) {
            request.addParameter("VerifiedAccessTrustProviderId", StringUtils.fromString((String)modifyVerifiedAccessTrustProviderRequest.getVerifiedAccessTrustProviderId()));
        }
        if ((oidcOptions = modifyVerifiedAccessTrustProviderRequest.getOidcOptions()) != null) {
            if (oidcOptions.getIssuer() != null) {
                request.addParameter("OidcOptions.Issuer", StringUtils.fromString((String)oidcOptions.getIssuer()));
            }
            if (oidcOptions.getAuthorizationEndpoint() != null) {
                request.addParameter("OidcOptions.AuthorizationEndpoint", StringUtils.fromString((String)oidcOptions.getAuthorizationEndpoint()));
            }
            if (oidcOptions.getTokenEndpoint() != null) {
                request.addParameter("OidcOptions.TokenEndpoint", StringUtils.fromString((String)oidcOptions.getTokenEndpoint()));
            }
            if (oidcOptions.getUserInfoEndpoint() != null) {
                request.addParameter("OidcOptions.UserInfoEndpoint", StringUtils.fromString((String)oidcOptions.getUserInfoEndpoint()));
            }
            if (oidcOptions.getClientId() != null) {
                request.addParameter("OidcOptions.ClientId", StringUtils.fromString((String)oidcOptions.getClientId()));
            }
            if (oidcOptions.getClientSecret() != null) {
                request.addParameter("OidcOptions.ClientSecret", StringUtils.fromString((String)oidcOptions.getClientSecret()));
            }
            if (oidcOptions.getScope() != null) {
                request.addParameter("OidcOptions.Scope", StringUtils.fromString((String)oidcOptions.getScope()));
            }
        }
        if ((deviceOptions = modifyVerifiedAccessTrustProviderRequest.getDeviceOptions()) != null && deviceOptions.getPublicSigningKeyUrl() != null) {
            request.addParameter("DeviceOptions.PublicSigningKeyUrl", StringUtils.fromString((String)deviceOptions.getPublicSigningKeyUrl()));
        }
        if (modifyVerifiedAccessTrustProviderRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)modifyVerifiedAccessTrustProviderRequest.getDescription()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)modifyVerifiedAccessTrustProviderRequest.getClientToken()));
        VerifiedAccessSseSpecificationRequest sseSpecification = modifyVerifiedAccessTrustProviderRequest.getSseSpecification();
        if (sseSpecification != null) {
            if (sseSpecification.getCustomerManagedKeyEnabled() != null) {
                request.addParameter("SseSpecification.CustomerManagedKeyEnabled", StringUtils.fromBoolean((Boolean)sseSpecification.getCustomerManagedKeyEnabled()));
            }
            if (sseSpecification.getKmsKeyArn() != null) {
                request.addParameter("SseSpecification.KmsKeyArn", StringUtils.fromString((String)sseSpecification.getKmsKeyArn()));
            }
        }
        return request;
    }
}

