/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AthenaIntegration;
import com.amazonaws.services.ec2.model.GetFlowLogsIntegrationTemplateRequest;
import com.amazonaws.services.ec2.model.IntegrateServices;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class GetFlowLogsIntegrationTemplateRequestMarshaller
implements Marshaller<Request<GetFlowLogsIntegrationTemplateRequest>, GetFlowLogsIntegrationTemplateRequest> {
    public Request<GetFlowLogsIntegrationTemplateRequest> marshall(GetFlowLogsIntegrationTemplateRequest getFlowLogsIntegrationTemplateRequest) {
        SdkInternalList integrateServicesAthenaIntegrationsList;
        IntegrateServices integrateServices;
        if (getFlowLogsIntegrationTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getFlowLogsIntegrationTemplateRequest, "AmazonEC2");
        request.addParameter("Action", "GetFlowLogsIntegrationTemplate");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getFlowLogsIntegrationTemplateRequest.getFlowLogId() != null) {
            request.addParameter("FlowLogId", StringUtils.fromString((String)getFlowLogsIntegrationTemplateRequest.getFlowLogId()));
        }
        if (getFlowLogsIntegrationTemplateRequest.getConfigDeliveryS3DestinationArn() != null) {
            request.addParameter("ConfigDeliveryS3DestinationArn", StringUtils.fromString((String)getFlowLogsIntegrationTemplateRequest.getConfigDeliveryS3DestinationArn()));
        }
        if (!((integrateServices = getFlowLogsIntegrationTemplateRequest.getIntegrateServices()) == null || (integrateServicesAthenaIntegrationsList = (SdkInternalList)integrateServices.getAthenaIntegrations()).isEmpty() && integrateServicesAthenaIntegrationsList.isAutoConstruct())) {
            int athenaIntegrationsListIndex = 1;
            for (AthenaIntegration integrateServicesAthenaIntegrationsListValue : integrateServicesAthenaIntegrationsList) {
                if (integrateServicesAthenaIntegrationsListValue.getIntegrationResultS3DestinationArn() != null) {
                    request.addParameter("IntegrateService.AthenaIntegration." + athenaIntegrationsListIndex + ".IntegrationResultS3DestinationArn", StringUtils.fromString((String)integrateServicesAthenaIntegrationsListValue.getIntegrationResultS3DestinationArn()));
                }
                if (integrateServicesAthenaIntegrationsListValue.getPartitionLoadFrequency() != null) {
                    request.addParameter("IntegrateService.AthenaIntegration." + athenaIntegrationsListIndex + ".PartitionLoadFrequency", StringUtils.fromString((String)integrateServicesAthenaIntegrationsListValue.getPartitionLoadFrequency()));
                }
                if (integrateServicesAthenaIntegrationsListValue.getPartitionStartDate() != null) {
                    request.addParameter("IntegrateService.AthenaIntegration." + athenaIntegrationsListIndex + ".PartitionStartDate", StringUtils.fromDate((Date)integrateServicesAthenaIntegrationsListValue.getPartitionStartDate()));
                }
                if (integrateServicesAthenaIntegrationsListValue.getPartitionEndDate() != null) {
                    request.addParameter("IntegrateService.AthenaIntegration." + athenaIntegrationsListIndex + ".PartitionEndDate", StringUtils.fromDate((Date)integrateServicesAthenaIntegrationsListValue.getPartitionEndDate()));
                }
                ++athenaIntegrationsListIndex;
            }
        }
        return request;
    }
}

