/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AssociationStatus;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class TargetNetwork
implements Serializable,
Cloneable {
    private String associationId;
    private String vpcId;
    private String targetNetworkId;
    private String clientVpnEndpointId;
    private AssociationStatus status;
    private SdkInternalList<String> securityGroups;

    public void setAssociationId(String associationId) {
        this.associationId = associationId;
    }

    public String getAssociationId() {
        return this.associationId;
    }

    public TargetNetwork withAssociationId(String associationId) {
        this.setAssociationId(associationId);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public TargetNetwork withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setTargetNetworkId(String targetNetworkId) {
        this.targetNetworkId = targetNetworkId;
    }

    public String getTargetNetworkId() {
        return this.targetNetworkId;
    }

    public TargetNetwork withTargetNetworkId(String targetNetworkId) {
        this.setTargetNetworkId(targetNetworkId);
        return this;
    }

    public void setClientVpnEndpointId(String clientVpnEndpointId) {
        this.clientVpnEndpointId = clientVpnEndpointId;
    }

    public String getClientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public TargetNetwork withClientVpnEndpointId(String clientVpnEndpointId) {
        this.setClientVpnEndpointId(clientVpnEndpointId);
        return this;
    }

    public void setStatus(AssociationStatus status) {
        this.status = status;
    }

    public AssociationStatus getStatus() {
        return this.status;
    }

    public TargetNetwork withStatus(AssociationStatus status) {
        this.setStatus(status);
        return this;
    }

    public List<String> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new SdkInternalList();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new SdkInternalList(securityGroups);
    }

    public TargetNetwork withSecurityGroups(String ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups((Collection<String>)new SdkInternalList(securityGroups.length));
        }
        for (String ele : securityGroups) {
            this.securityGroups.add((Object)ele);
        }
        return this;
    }

    public TargetNetwork withSecurityGroups(Collection<String> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssociationId() != null) {
            sb.append("AssociationId: ").append(this.getAssociationId()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getTargetNetworkId() != null) {
            sb.append("TargetNetworkId: ").append(this.getTargetNetworkId()).append(",");
        }
        if (this.getClientVpnEndpointId() != null) {
            sb.append("ClientVpnEndpointId: ").append(this.getClientVpnEndpointId()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetNetwork)) {
            return false;
        }
        TargetNetwork other = (TargetNetwork)obj;
        if (other.getAssociationId() == null ^ this.getAssociationId() == null) {
            return false;
        }
        if (other.getAssociationId() != null && !other.getAssociationId().equals(this.getAssociationId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getTargetNetworkId() == null ^ this.getTargetNetworkId() == null) {
            return false;
        }
        if (other.getTargetNetworkId() != null && !other.getTargetNetworkId().equals(this.getTargetNetworkId())) {
            return false;
        }
        if (other.getClientVpnEndpointId() == null ^ this.getClientVpnEndpointId() == null) {
            return false;
        }
        if (other.getClientVpnEndpointId() != null && !other.getClientVpnEndpointId().equals(this.getClientVpnEndpointId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        return other.getSecurityGroups() == null || other.getSecurityGroups().equals(this.getSecurityGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssociationId() == null ? 0 : this.getAssociationId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getTargetNetworkId() == null ? 0 : this.getTargetNetworkId().hashCode());
        hashCode = 31 * hashCode + (this.getClientVpnEndpointId() == null ? 0 : this.getClientVpnEndpointId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        return hashCode;
    }

    public TargetNetwork clone() {
        try {
            return (TargetNetwork)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

