/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceResult;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeVerifiedAccessTrustProvidersResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * Details about the Verified Access trust providers.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<VerifiedAccessTrustProvider> verifiedAccessTrustProviders;
    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * Details about the Verified Access trust providers.
     * </p>
     * 
     * @return Details about the Verified Access trust providers.
     */

    public java.util.List<VerifiedAccessTrustProvider> getVerifiedAccessTrustProviders() {
        if (verifiedAccessTrustProviders == null) {
            verifiedAccessTrustProviders = new com.amazonaws.internal.SdkInternalList<VerifiedAccessTrustProvider>();
        }
        return verifiedAccessTrustProviders;
    }

    /**
     * <p>
     * Details about the Verified Access trust providers.
     * </p>
     * 
     * @param verifiedAccessTrustProviders
     *        Details about the Verified Access trust providers.
     */

    public void setVerifiedAccessTrustProviders(java.util.Collection<VerifiedAccessTrustProvider> verifiedAccessTrustProviders) {
        if (verifiedAccessTrustProviders == null) {
            this.verifiedAccessTrustProviders = null;
            return;
        }

        this.verifiedAccessTrustProviders = new com.amazonaws.internal.SdkInternalList<VerifiedAccessTrustProvider>(verifiedAccessTrustProviders);
    }

    /**
     * <p>
     * Details about the Verified Access trust providers.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setVerifiedAccessTrustProviders(java.util.Collection)} or
     * {@link #withVerifiedAccessTrustProviders(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param verifiedAccessTrustProviders
     *        Details about the Verified Access trust providers.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeVerifiedAccessTrustProvidersResult withVerifiedAccessTrustProviders(VerifiedAccessTrustProvider... verifiedAccessTrustProviders) {
        if (this.verifiedAccessTrustProviders == null) {
            setVerifiedAccessTrustProviders(new com.amazonaws.internal.SdkInternalList<VerifiedAccessTrustProvider>(verifiedAccessTrustProviders.length));
        }
        for (VerifiedAccessTrustProvider ele : verifiedAccessTrustProviders) {
            this.verifiedAccessTrustProviders.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Details about the Verified Access trust providers.
     * </p>
     * 
     * @param verifiedAccessTrustProviders
     *        Details about the Verified Access trust providers.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeVerifiedAccessTrustProvidersResult withVerifiedAccessTrustProviders(
            java.util.Collection<VerifiedAccessTrustProvider> verifiedAccessTrustProviders) {
        setVerifiedAccessTrustProviders(verifiedAccessTrustProviders);
        return this;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @param nextToken
     *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *        more results to return.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @param nextToken
     *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *        more results to return.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeVerifiedAccessTrustProvidersResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getVerifiedAccessTrustProviders() != null)
            sb.append("VerifiedAccessTrustProviders: ").append(getVerifiedAccessTrustProviders()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeVerifiedAccessTrustProvidersResult == false)
            return false;
        DescribeVerifiedAccessTrustProvidersResult other = (DescribeVerifiedAccessTrustProvidersResult) obj;
        if (other.getVerifiedAccessTrustProviders() == null ^ this.getVerifiedAccessTrustProviders() == null)
            return false;
        if (other.getVerifiedAccessTrustProviders() != null && other.getVerifiedAccessTrustProviders().equals(this.getVerifiedAccessTrustProviders()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getVerifiedAccessTrustProviders() == null) ? 0 : getVerifiedAccessTrustProviders().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public DescribeVerifiedAccessTrustProvidersResult clone() {
        try {
            return (DescribeVerifiedAccessTrustProvidersResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }
}
