/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeFastLaunchImagesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeFastLaunchImagesRequestMarshaller
implements Marshaller<Request<DescribeFastLaunchImagesRequest>, DescribeFastLaunchImagesRequest> {
    public Request<DescribeFastLaunchImagesRequest> marshall(DescribeFastLaunchImagesRequest describeFastLaunchImagesRequest) {
        SdkInternalList describeFastLaunchImagesRequestFiltersList;
        if (describeFastLaunchImagesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeFastLaunchImagesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeFastLaunchImages");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeFastLaunchImagesRequestImageIdsList = (SdkInternalList)describeFastLaunchImagesRequest.getImageIds();
        if (!describeFastLaunchImagesRequestImageIdsList.isEmpty() || !describeFastLaunchImagesRequestImageIdsList.isAutoConstruct()) {
            int imageIdsListIndex = 1;
            for (String describeFastLaunchImagesRequestImageIdsListValue : describeFastLaunchImagesRequestImageIdsList) {
                if (describeFastLaunchImagesRequestImageIdsListValue != null) {
                    request.addParameter("ImageId." + imageIdsListIndex, StringUtils.fromString((String)describeFastLaunchImagesRequestImageIdsListValue));
                }
                ++imageIdsListIndex;
            }
        }
        if (!(describeFastLaunchImagesRequestFiltersList = (SdkInternalList)describeFastLaunchImagesRequest.getFilters()).isEmpty() || !describeFastLaunchImagesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeFastLaunchImagesRequestFiltersListValue : describeFastLaunchImagesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeFastLaunchImagesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeFastLaunchImagesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeFastLaunchImagesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeFastLaunchImagesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeFastLaunchImagesRequest.getMaxResults()));
        }
        if (describeFastLaunchImagesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeFastLaunchImagesRequest.getNextToken()));
        }
        return request;
    }
}

