/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ModifyIpamPoolRequest;
import com.amazonaws.services.ec2.model.RequestIpamResourceTag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyIpamPoolRequestMarshaller
implements Marshaller<Request<ModifyIpamPoolRequest>, ModifyIpamPoolRequest> {
    public Request<ModifyIpamPoolRequest> marshall(ModifyIpamPoolRequest modifyIpamPoolRequest) {
        SdkInternalList modifyIpamPoolRequestRemoveAllocationResourceTagsList;
        SdkInternalList modifyIpamPoolRequestAddAllocationResourceTagsList;
        if (modifyIpamPoolRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyIpamPoolRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyIpamPool");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyIpamPoolRequest.getIpamPoolId() != null) {
            request.addParameter("IpamPoolId", StringUtils.fromString((String)modifyIpamPoolRequest.getIpamPoolId()));
        }
        if (modifyIpamPoolRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)modifyIpamPoolRequest.getDescription()));
        }
        if (modifyIpamPoolRequest.getAutoImport() != null) {
            request.addParameter("AutoImport", StringUtils.fromBoolean((Boolean)modifyIpamPoolRequest.getAutoImport()));
        }
        if (modifyIpamPoolRequest.getAllocationMinNetmaskLength() != null) {
            request.addParameter("AllocationMinNetmaskLength", StringUtils.fromInteger((Integer)modifyIpamPoolRequest.getAllocationMinNetmaskLength()));
        }
        if (modifyIpamPoolRequest.getAllocationMaxNetmaskLength() != null) {
            request.addParameter("AllocationMaxNetmaskLength", StringUtils.fromInteger((Integer)modifyIpamPoolRequest.getAllocationMaxNetmaskLength()));
        }
        if (modifyIpamPoolRequest.getAllocationDefaultNetmaskLength() != null) {
            request.addParameter("AllocationDefaultNetmaskLength", StringUtils.fromInteger((Integer)modifyIpamPoolRequest.getAllocationDefaultNetmaskLength()));
        }
        if (modifyIpamPoolRequest.getClearAllocationDefaultNetmaskLength() != null) {
            request.addParameter("ClearAllocationDefaultNetmaskLength", StringUtils.fromBoolean((Boolean)modifyIpamPoolRequest.getClearAllocationDefaultNetmaskLength()));
        }
        if (!(modifyIpamPoolRequestAddAllocationResourceTagsList = (SdkInternalList)modifyIpamPoolRequest.getAddAllocationResourceTags()).isEmpty() || !modifyIpamPoolRequestAddAllocationResourceTagsList.isAutoConstruct()) {
            int addAllocationResourceTagsListIndex = 1;
            for (RequestIpamResourceTag modifyIpamPoolRequestAddAllocationResourceTagsListValue : modifyIpamPoolRequestAddAllocationResourceTagsList) {
                if (modifyIpamPoolRequestAddAllocationResourceTagsListValue.getKey() != null) {
                    request.addParameter("AddAllocationResourceTag." + addAllocationResourceTagsListIndex + ".Key", StringUtils.fromString((String)modifyIpamPoolRequestAddAllocationResourceTagsListValue.getKey()));
                }
                if (modifyIpamPoolRequestAddAllocationResourceTagsListValue.getValue() != null) {
                    request.addParameter("AddAllocationResourceTag." + addAllocationResourceTagsListIndex + ".Value", StringUtils.fromString((String)modifyIpamPoolRequestAddAllocationResourceTagsListValue.getValue()));
                }
                ++addAllocationResourceTagsListIndex;
            }
        }
        if (!(modifyIpamPoolRequestRemoveAllocationResourceTagsList = (SdkInternalList)modifyIpamPoolRequest.getRemoveAllocationResourceTags()).isEmpty() || !modifyIpamPoolRequestRemoveAllocationResourceTagsList.isAutoConstruct()) {
            int removeAllocationResourceTagsListIndex = 1;
            for (RequestIpamResourceTag modifyIpamPoolRequestRemoveAllocationResourceTagsListValue : modifyIpamPoolRequestRemoveAllocationResourceTagsList) {
                if (modifyIpamPoolRequestRemoveAllocationResourceTagsListValue.getKey() != null) {
                    request.addParameter("RemoveAllocationResourceTag." + removeAllocationResourceTagsListIndex + ".Key", StringUtils.fromString((String)modifyIpamPoolRequestRemoveAllocationResourceTagsListValue.getKey()));
                }
                if (modifyIpamPoolRequestRemoveAllocationResourceTagsListValue.getValue() != null) {
                    request.addParameter("RemoveAllocationResourceTag." + removeAllocationResourceTagsListIndex + ".Value", StringUtils.fromString((String)modifyIpamPoolRequestRemoveAllocationResourceTagsListValue.getValue()));
                }
                ++removeAllocationResourceTagsListIndex;
            }
        }
        return request;
    }
}

