/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.transform.DescribeInstanceTypesRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeInstanceTypesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeInstanceTypesRequest> {
    private SdkInternalList<String> instanceTypes;
    private SdkInternalList<Filter> filters;
    private Integer maxResults;
    private String nextToken;

    public List<String> getInstanceTypes() {
        if (this.instanceTypes == null) {
            this.instanceTypes = new SdkInternalList();
        }
        return this.instanceTypes;
    }

    public void setInstanceTypes(Collection<String> instanceTypes) {
        if (instanceTypes == null) {
            this.instanceTypes = null;
            return;
        }
        this.instanceTypes = new SdkInternalList(instanceTypes);
    }

    public DescribeInstanceTypesRequest withInstanceTypes(String ... instanceTypes) {
        if (this.instanceTypes == null) {
            this.setInstanceTypes((Collection<String>)new SdkInternalList(instanceTypes.length));
        }
        for (String ele : instanceTypes) {
            this.instanceTypes.add((Object)ele);
        }
        return this;
    }

    public DescribeInstanceTypesRequest withInstanceTypes(Collection<String> instanceTypes) {
        this.setInstanceTypes(instanceTypes);
        return this;
    }

    public DescribeInstanceTypesRequest withInstanceTypes(InstanceType ... instanceTypes) {
        SdkInternalList instanceTypesCopy = new SdkInternalList(instanceTypes.length);
        for (InstanceType value : instanceTypes) {
            instanceTypesCopy.add((Object)value.toString());
        }
        if (this.getInstanceTypes() == null) {
            this.setInstanceTypes((Collection<String>)instanceTypesCopy);
        } else {
            this.getInstanceTypes().addAll((Collection<String>)instanceTypesCopy);
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList(filters);
    }

    public DescribeInstanceTypesRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters((Collection<Filter>)new SdkInternalList(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add((Object)ele);
        }
        return this;
    }

    public DescribeInstanceTypesRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeInstanceTypesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeInstanceTypesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    @Override
    public Request<DescribeInstanceTypesRequest> getDryRunRequest() {
        Request<DescribeInstanceTypesRequest> request = new DescribeInstanceTypesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceTypes() != null) {
            sb.append("InstanceTypes: ").append(this.getInstanceTypes()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceTypesRequest)) {
            return false;
        }
        DescribeInstanceTypesRequest other = (DescribeInstanceTypesRequest)obj;
        if (other.getInstanceTypes() == null ^ this.getInstanceTypes() == null) {
            return false;
        }
        if (other.getInstanceTypes() != null && !other.getInstanceTypes().equals(this.getInstanceTypes())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceTypes() == null ? 0 : this.getInstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeInstanceTypesRequest clone() {
        return (DescribeInstanceTypesRequest)super.clone();
    }
}

