/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.PortRange;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class FirewallStatelessRule
implements Serializable,
Cloneable {
    private String ruleGroupArn;
    private SdkInternalList<String> sources;
    private SdkInternalList<String> destinations;
    private SdkInternalList<PortRange> sourcePorts;
    private SdkInternalList<PortRange> destinationPorts;
    private SdkInternalList<Integer> protocols;
    private String ruleAction;
    private Integer priority;

    public void setRuleGroupArn(String ruleGroupArn) {
        this.ruleGroupArn = ruleGroupArn;
    }

    public String getRuleGroupArn() {
        return this.ruleGroupArn;
    }

    public FirewallStatelessRule withRuleGroupArn(String ruleGroupArn) {
        this.setRuleGroupArn(ruleGroupArn);
        return this;
    }

    public List<String> getSources() {
        if (this.sources == null) {
            this.sources = new SdkInternalList();
        }
        return this.sources;
    }

    public void setSources(Collection<String> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new SdkInternalList(sources);
    }

    public FirewallStatelessRule withSources(String ... sources) {
        if (this.sources == null) {
            this.setSources((Collection<String>)new SdkInternalList(sources.length));
        }
        for (String ele : sources) {
            this.sources.add((Object)ele);
        }
        return this;
    }

    public FirewallStatelessRule withSources(Collection<String> sources) {
        this.setSources(sources);
        return this;
    }

    public List<String> getDestinations() {
        if (this.destinations == null) {
            this.destinations = new SdkInternalList();
        }
        return this.destinations;
    }

    public void setDestinations(Collection<String> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new SdkInternalList(destinations);
    }

    public FirewallStatelessRule withDestinations(String ... destinations) {
        if (this.destinations == null) {
            this.setDestinations((Collection<String>)new SdkInternalList(destinations.length));
        }
        for (String ele : destinations) {
            this.destinations.add((Object)ele);
        }
        return this;
    }

    public FirewallStatelessRule withDestinations(Collection<String> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public List<PortRange> getSourcePorts() {
        if (this.sourcePorts == null) {
            this.sourcePorts = new SdkInternalList();
        }
        return this.sourcePorts;
    }

    public void setSourcePorts(Collection<PortRange> sourcePorts) {
        if (sourcePorts == null) {
            this.sourcePorts = null;
            return;
        }
        this.sourcePorts = new SdkInternalList(sourcePorts);
    }

    public FirewallStatelessRule withSourcePorts(PortRange ... sourcePorts) {
        if (this.sourcePorts == null) {
            this.setSourcePorts((Collection<PortRange>)new SdkInternalList(sourcePorts.length));
        }
        for (PortRange ele : sourcePorts) {
            this.sourcePorts.add((Object)ele);
        }
        return this;
    }

    public FirewallStatelessRule withSourcePorts(Collection<PortRange> sourcePorts) {
        this.setSourcePorts(sourcePorts);
        return this;
    }

    public List<PortRange> getDestinationPorts() {
        if (this.destinationPorts == null) {
            this.destinationPorts = new SdkInternalList();
        }
        return this.destinationPorts;
    }

    public void setDestinationPorts(Collection<PortRange> destinationPorts) {
        if (destinationPorts == null) {
            this.destinationPorts = null;
            return;
        }
        this.destinationPorts = new SdkInternalList(destinationPorts);
    }

    public FirewallStatelessRule withDestinationPorts(PortRange ... destinationPorts) {
        if (this.destinationPorts == null) {
            this.setDestinationPorts((Collection<PortRange>)new SdkInternalList(destinationPorts.length));
        }
        for (PortRange ele : destinationPorts) {
            this.destinationPorts.add((Object)ele);
        }
        return this;
    }

    public FirewallStatelessRule withDestinationPorts(Collection<PortRange> destinationPorts) {
        this.setDestinationPorts(destinationPorts);
        return this;
    }

    public List<Integer> getProtocols() {
        if (this.protocols == null) {
            this.protocols = new SdkInternalList();
        }
        return this.protocols;
    }

    public void setProtocols(Collection<Integer> protocols) {
        if (protocols == null) {
            this.protocols = null;
            return;
        }
        this.protocols = new SdkInternalList(protocols);
    }

    public FirewallStatelessRule withProtocols(Integer ... protocols) {
        if (this.protocols == null) {
            this.setProtocols((Collection<Integer>)new SdkInternalList(protocols.length));
        }
        for (Integer ele : protocols) {
            this.protocols.add((Object)ele);
        }
        return this;
    }

    public FirewallStatelessRule withProtocols(Collection<Integer> protocols) {
        this.setProtocols(protocols);
        return this;
    }

    public void setRuleAction(String ruleAction) {
        this.ruleAction = ruleAction;
    }

    public String getRuleAction() {
        return this.ruleAction;
    }

    public FirewallStatelessRule withRuleAction(String ruleAction) {
        this.setRuleAction(ruleAction);
        return this;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public FirewallStatelessRule withPriority(Integer priority) {
        this.setPriority(priority);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleGroupArn() != null) {
            sb.append("RuleGroupArn: ").append(this.getRuleGroupArn()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources()).append(",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getSourcePorts() != null) {
            sb.append("SourcePorts: ").append(this.getSourcePorts()).append(",");
        }
        if (this.getDestinationPorts() != null) {
            sb.append("DestinationPorts: ").append(this.getDestinationPorts()).append(",");
        }
        if (this.getProtocols() != null) {
            sb.append("Protocols: ").append(this.getProtocols()).append(",");
        }
        if (this.getRuleAction() != null) {
            sb.append("RuleAction: ").append(this.getRuleAction()).append(",");
        }
        if (this.getPriority() != null) {
            sb.append("Priority: ").append(this.getPriority());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallStatelessRule)) {
            return false;
        }
        FirewallStatelessRule other = (FirewallStatelessRule)obj;
        if (other.getRuleGroupArn() == null ^ this.getRuleGroupArn() == null) {
            return false;
        }
        if (other.getRuleGroupArn() != null && !other.getRuleGroupArn().equals(this.getRuleGroupArn())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        if (other.getSources() != null && !other.getSources().equals(this.getSources())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getSourcePorts() == null ^ this.getSourcePorts() == null) {
            return false;
        }
        if (other.getSourcePorts() != null && !other.getSourcePorts().equals(this.getSourcePorts())) {
            return false;
        }
        if (other.getDestinationPorts() == null ^ this.getDestinationPorts() == null) {
            return false;
        }
        if (other.getDestinationPorts() != null && !other.getDestinationPorts().equals(this.getDestinationPorts())) {
            return false;
        }
        if (other.getProtocols() == null ^ this.getProtocols() == null) {
            return false;
        }
        if (other.getProtocols() != null && !other.getProtocols().equals(this.getProtocols())) {
            return false;
        }
        if (other.getRuleAction() == null ^ this.getRuleAction() == null) {
            return false;
        }
        if (other.getRuleAction() != null && !other.getRuleAction().equals(this.getRuleAction())) {
            return false;
        }
        if (other.getPriority() == null ^ this.getPriority() == null) {
            return false;
        }
        return other.getPriority() == null || other.getPriority().equals(this.getPriority());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleGroupArn() == null ? 0 : this.getRuleGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getSourcePorts() == null ? 0 : this.getSourcePorts().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationPorts() == null ? 0 : this.getDestinationPorts().hashCode());
        hashCode = 31 * hashCode + (this.getProtocols() == null ? 0 : this.getProtocols().hashCode());
        hashCode = 31 * hashCode + (this.getRuleAction() == null ? 0 : this.getRuleAction().hashCode());
        hashCode = 31 * hashCode + (this.getPriority() == null ? 0 : this.getPriority().hashCode());
        return hashCode;
    }

    public FirewallStatelessRule clone() {
        try {
            return (FirewallStatelessRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

