/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.InstanceRequirements;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.SpotFleetMonitoring;
import com.amazonaws.services.ec2.model.SpotFleetTagSpecification;
import com.amazonaws.services.ec2.model.SpotPlacement;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class SpotFleetLaunchSpecification
implements Serializable,
Cloneable {
    private SdkInternalList<GroupIdentifier> securityGroups;
    private String addressingType;
    private SdkInternalList<BlockDeviceMapping> blockDeviceMappings;
    private Boolean ebsOptimized;
    private IamInstanceProfileSpecification iamInstanceProfile;
    private String imageId;
    private String instanceType;
    private String kernelId;
    private String keyName;
    private SpotFleetMonitoring monitoring;
    private SdkInternalList<InstanceNetworkInterfaceSpecification> networkInterfaces;
    private SpotPlacement placement;
    private String ramdiskId;
    private String spotPrice;
    private String subnetId;
    private String userData;
    private Double weightedCapacity;
    private SdkInternalList<SpotFleetTagSpecification> tagSpecifications;
    private InstanceRequirements instanceRequirements;

    public List<GroupIdentifier> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new SdkInternalList();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<GroupIdentifier> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new SdkInternalList(securityGroups);
    }

    public SpotFleetLaunchSpecification withSecurityGroups(GroupIdentifier ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups((Collection<GroupIdentifier>)new SdkInternalList(securityGroups.length));
        }
        for (GroupIdentifier ele : securityGroups) {
            this.securityGroups.add((Object)ele);
        }
        return this;
    }

    public SpotFleetLaunchSpecification withSecurityGroups(Collection<GroupIdentifier> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setAddressingType(String addressingType) {
        this.addressingType = addressingType;
    }

    public String getAddressingType() {
        return this.addressingType;
    }

    public SpotFleetLaunchSpecification withAddressingType(String addressingType) {
        this.setAddressingType(addressingType);
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new SdkInternalList();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new SdkInternalList(blockDeviceMappings);
    }

    public SpotFleetLaunchSpecification withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings((Collection<BlockDeviceMapping>)new SdkInternalList(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping ele : blockDeviceMappings) {
            this.blockDeviceMappings.add((Object)ele);
        }
        return this;
    }

    public SpotFleetLaunchSpecification withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public SpotFleetLaunchSpecification withEbsOptimized(Boolean ebsOptimized) {
        this.setEbsOptimized(ebsOptimized);
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setIamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
        this.iamInstanceProfile = iamInstanceProfile;
    }

    public IamInstanceProfileSpecification getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public SpotFleetLaunchSpecification withIamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
        this.setIamInstanceProfile(iamInstanceProfile);
        return this;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public SpotFleetLaunchSpecification withImageId(String imageId) {
        this.setImageId(imageId);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public SpotFleetLaunchSpecification withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setInstanceType(InstanceType instanceType) {
        this.withInstanceType(instanceType);
    }

    public SpotFleetLaunchSpecification withInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public SpotFleetLaunchSpecification withKernelId(String kernelId) {
        this.setKernelId(kernelId);
        return this;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public SpotFleetLaunchSpecification withKeyName(String keyName) {
        this.setKeyName(keyName);
        return this;
    }

    public void setMonitoring(SpotFleetMonitoring monitoring) {
        this.monitoring = monitoring;
    }

    public SpotFleetMonitoring getMonitoring() {
        return this.monitoring;
    }

    public SpotFleetLaunchSpecification withMonitoring(SpotFleetMonitoring monitoring) {
        this.setMonitoring(monitoring);
        return this;
    }

    public List<InstanceNetworkInterfaceSpecification> getNetworkInterfaces() {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new SdkInternalList();
        }
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
        if (networkInterfaces == null) {
            this.networkInterfaces = null;
            return;
        }
        this.networkInterfaces = new SdkInternalList(networkInterfaces);
    }

    public SpotFleetLaunchSpecification withNetworkInterfaces(InstanceNetworkInterfaceSpecification ... networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.setNetworkInterfaces((Collection<InstanceNetworkInterfaceSpecification>)new SdkInternalList(networkInterfaces.length));
        }
        for (InstanceNetworkInterfaceSpecification ele : networkInterfaces) {
            this.networkInterfaces.add((Object)ele);
        }
        return this;
    }

    public SpotFleetLaunchSpecification withNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
        this.setNetworkInterfaces(networkInterfaces);
        return this;
    }

    public void setPlacement(SpotPlacement placement) {
        this.placement = placement;
    }

    public SpotPlacement getPlacement() {
        return this.placement;
    }

    public SpotFleetLaunchSpecification withPlacement(SpotPlacement placement) {
        this.setPlacement(placement);
        return this;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public SpotFleetLaunchSpecification withRamdiskId(String ramdiskId) {
        this.setRamdiskId(ramdiskId);
        return this;
    }

    public void setSpotPrice(String spotPrice) {
        this.spotPrice = spotPrice;
    }

    public String getSpotPrice() {
        return this.spotPrice;
    }

    public SpotFleetLaunchSpecification withSpotPrice(String spotPrice) {
        this.setSpotPrice(spotPrice);
        return this;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public SpotFleetLaunchSpecification withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public String getUserData() {
        return this.userData;
    }

    public SpotFleetLaunchSpecification withUserData(String userData) {
        this.setUserData(userData);
        return this;
    }

    public void setWeightedCapacity(Double weightedCapacity) {
        this.weightedCapacity = weightedCapacity;
    }

    public Double getWeightedCapacity() {
        return this.weightedCapacity;
    }

    public SpotFleetLaunchSpecification withWeightedCapacity(Double weightedCapacity) {
        this.setWeightedCapacity(weightedCapacity);
        return this;
    }

    public List<SpotFleetTagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<SpotFleetTagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public SpotFleetLaunchSpecification withTagSpecifications(SpotFleetTagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<SpotFleetTagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (SpotFleetTagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public SpotFleetLaunchSpecification withTagSpecifications(Collection<SpotFleetTagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public void setInstanceRequirements(InstanceRequirements instanceRequirements) {
        this.instanceRequirements = instanceRequirements;
    }

    public InstanceRequirements getInstanceRequirements() {
        return this.instanceRequirements;
    }

    public SpotFleetLaunchSpecification withInstanceRequirements(InstanceRequirements instanceRequirements) {
        this.setInstanceRequirements(instanceRequirements);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getAddressingType() != null) {
            sb.append("AddressingType: ").append(this.getAddressingType()).append(",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.getBlockDeviceMappings()).append(",");
        }
        if (this.getEbsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.getEbsOptimized()).append(",");
        }
        if (this.getIamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(this.getIamInstanceProfile()).append(",");
        }
        if (this.getImageId() != null) {
            sb.append("ImageId: ").append(this.getImageId()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getKernelId() != null) {
            sb.append("KernelId: ").append(this.getKernelId()).append(",");
        }
        if (this.getKeyName() != null) {
            sb.append("KeyName: ").append(this.getKeyName()).append(",");
        }
        if (this.getMonitoring() != null) {
            sb.append("Monitoring: ").append(this.getMonitoring()).append(",");
        }
        if (this.getNetworkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.getNetworkInterfaces()).append(",");
        }
        if (this.getPlacement() != null) {
            sb.append("Placement: ").append(this.getPlacement()).append(",");
        }
        if (this.getRamdiskId() != null) {
            sb.append("RamdiskId: ").append(this.getRamdiskId()).append(",");
        }
        if (this.getSpotPrice() != null) {
            sb.append("SpotPrice: ").append(this.getSpotPrice()).append(",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: ").append(this.getSubnetId()).append(",");
        }
        if (this.getUserData() != null) {
            sb.append("UserData: ").append(this.getUserData()).append(",");
        }
        if (this.getWeightedCapacity() != null) {
            sb.append("WeightedCapacity: ").append(this.getWeightedCapacity()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getInstanceRequirements() != null) {
            sb.append("InstanceRequirements: ").append(this.getInstanceRequirements());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetLaunchSpecification)) {
            return false;
        }
        SpotFleetLaunchSpecification other = (SpotFleetLaunchSpecification)obj;
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getAddressingType() == null ^ this.getAddressingType() == null) {
            return false;
        }
        if (other.getAddressingType() != null && !other.getAddressingType().equals(this.getAddressingType())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getEbsOptimized() == null ^ this.getEbsOptimized() == null) {
            return false;
        }
        if (other.getEbsOptimized() != null && !other.getEbsOptimized().equals(this.getEbsOptimized())) {
            return false;
        }
        if (other.getIamInstanceProfile() == null ^ this.getIamInstanceProfile() == null) {
            return false;
        }
        if (other.getIamInstanceProfile() != null && !other.getIamInstanceProfile().equals(this.getIamInstanceProfile())) {
            return false;
        }
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getMonitoring() == null ^ this.getMonitoring() == null) {
            return false;
        }
        if (other.getMonitoring() != null && !other.getMonitoring().equals(this.getMonitoring())) {
            return false;
        }
        if (other.getNetworkInterfaces() == null ^ this.getNetworkInterfaces() == null) {
            return false;
        }
        if (other.getNetworkInterfaces() != null && !other.getNetworkInterfaces().equals(this.getNetworkInterfaces())) {
            return false;
        }
        if (other.getPlacement() == null ^ this.getPlacement() == null) {
            return false;
        }
        if (other.getPlacement() != null && !other.getPlacement().equals(this.getPlacement())) {
            return false;
        }
        if (other.getRamdiskId() == null ^ this.getRamdiskId() == null) {
            return false;
        }
        if (other.getRamdiskId() != null && !other.getRamdiskId().equals(this.getRamdiskId())) {
            return false;
        }
        if (other.getSpotPrice() == null ^ this.getSpotPrice() == null) {
            return false;
        }
        if (other.getSpotPrice() != null && !other.getSpotPrice().equals(this.getSpotPrice())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getUserData() == null ^ this.getUserData() == null) {
            return false;
        }
        if (other.getUserData() != null && !other.getUserData().equals(this.getUserData())) {
            return false;
        }
        if (other.getWeightedCapacity() == null ^ this.getWeightedCapacity() == null) {
            return false;
        }
        if (other.getWeightedCapacity() != null && !other.getWeightedCapacity().equals(this.getWeightedCapacity())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getInstanceRequirements() == null ^ this.getInstanceRequirements() == null) {
            return false;
        }
        return other.getInstanceRequirements() == null || other.getInstanceRequirements().equals(this.getInstanceRequirements());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getAddressingType() == null ? 0 : this.getAddressingType().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getEbsOptimized() == null ? 0 : this.getEbsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.getIamInstanceProfile() == null ? 0 : this.getIamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoring() == null ? 0 : this.getMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaces() == null ? 0 : this.getNetworkInterfaces().hashCode());
        hashCode = 31 * hashCode + (this.getPlacement() == null ? 0 : this.getPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getRamdiskId() == null ? 0 : this.getRamdiskId().hashCode());
        hashCode = 31 * hashCode + (this.getSpotPrice() == null ? 0 : this.getSpotPrice().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getUserData() == null ? 0 : this.getUserData().hashCode());
        hashCode = 31 * hashCode + (this.getWeightedCapacity() == null ? 0 : this.getWeightedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceRequirements() == null ? 0 : this.getInstanceRequirements().hashCode());
        return hashCode;
    }

    public SpotFleetLaunchSpecification clone() {
        try {
            return (SpotFleetLaunchSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

