/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.PurchaseRequest;
import com.amazonaws.services.ec2.model.transform.PurchaseScheduledInstancesRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PurchaseScheduledInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<PurchaseScheduledInstancesRequest> {
    private String clientToken;
    private SdkInternalList<PurchaseRequest> purchaseRequests;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public PurchaseScheduledInstancesRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<PurchaseRequest> getPurchaseRequests() {
        if (this.purchaseRequests == null) {
            this.purchaseRequests = new SdkInternalList();
        }
        return this.purchaseRequests;
    }

    public void setPurchaseRequests(Collection<PurchaseRequest> purchaseRequests) {
        if (purchaseRequests == null) {
            this.purchaseRequests = null;
            return;
        }
        this.purchaseRequests = new SdkInternalList(purchaseRequests);
    }

    public PurchaseScheduledInstancesRequest withPurchaseRequests(PurchaseRequest ... purchaseRequests) {
        if (this.purchaseRequests == null) {
            this.setPurchaseRequests((Collection<PurchaseRequest>)new SdkInternalList(purchaseRequests.length));
        }
        for (PurchaseRequest ele : purchaseRequests) {
            this.purchaseRequests.add((Object)ele);
        }
        return this;
    }

    public PurchaseScheduledInstancesRequest withPurchaseRequests(Collection<PurchaseRequest> purchaseRequests) {
        this.setPurchaseRequests(purchaseRequests);
        return this;
    }

    @Override
    public Request<PurchaseScheduledInstancesRequest> getDryRunRequest() {
        Request<PurchaseScheduledInstancesRequest> request = new PurchaseScheduledInstancesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getPurchaseRequests() != null) {
            sb.append("PurchaseRequests: ").append(this.getPurchaseRequests());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseScheduledInstancesRequest)) {
            return false;
        }
        PurchaseScheduledInstancesRequest other = (PurchaseScheduledInstancesRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getPurchaseRequests() == null ^ this.getPurchaseRequests() == null) {
            return false;
        }
        return other.getPurchaseRequests() == null || other.getPurchaseRequests().equals(this.getPurchaseRequests());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getPurchaseRequests() == null ? 0 : this.getPurchaseRequests().hashCode());
        return hashCode;
    }

    public PurchaseScheduledInstancesRequest clone() {
        return (PurchaseScheduledInstancesRequest)super.clone();
    }
}

