/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;

public class SecurityGroupUtils {
    private static final String INVALID_GROUP_NOT_FOUND = "InvalidGroup.NotFound";

    public static boolean doesSecurityGroupExist(AmazonEC2 ec2, String securityGroupName) throws AmazonClientException, AmazonServiceException {
        DescribeSecurityGroupsRequest securityGroupsRequest = new DescribeSecurityGroupsRequest().withGroupNames(securityGroupName);
        try {
            ec2.describeSecurityGroups(securityGroupsRequest);
            return true;
        }
        catch (AmazonServiceException ase) {
            if (INVALID_GROUP_NOT_FOUND.equals(ase.getErrorCode())) {
                return false;
            }
            throw ase;
        }
    }
}

