/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.JmesPathSubExpression;
import com.amazonaws.jmespath.JmesPathVisitor;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class InstanceTerminated {
    InstanceTerminated() {
    }

    static class IsStoppingMatcher
    extends WaiterAcceptor<DescribeInstancesResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsStoppingMatcher() {
        }

        public boolean matches(DescribeInstancesResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAny((JsonNode)expectedResult, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"stopping\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathField("Reservations")), (JmesPathExpression)new JmesPathField("Instances"))), (JmesPathExpression)new JmesPathSubExpression(new JmesPathExpression[]{new JmesPathField("State"), new JmesPathField("Name")}));
        }
    }

    static class IsPendingMatcher
    extends WaiterAcceptor<DescribeInstancesResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsPendingMatcher() {
        }

        public boolean matches(DescribeInstancesResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAny((JsonNode)expectedResult, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"pending\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathField("Reservations")), (JmesPathExpression)new JmesPathField("Instances"))), (JmesPathExpression)new JmesPathSubExpression(new JmesPathExpression[]{new JmesPathField("State"), new JmesPathField("Name")}));
        }
    }

    static class IsTerminatedMatcher
    extends WaiterAcceptor<DescribeInstancesResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsTerminatedMatcher() {
        }

        public boolean matches(DescribeInstancesResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAll((JsonNode)expectedResult, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"terminated\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathField("Reservations")), (JmesPathExpression)new JmesPathField("Instances"))), (JmesPathExpression)new JmesPathSubExpression(new JmesPathExpression[]{new JmesPathField("State"), new JmesPathField("Name")}));
        }
    }
}

