/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateVolumeRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateVolumeRequestMarshaller
implements Marshaller<Request<CreateVolumeRequest>, CreateVolumeRequest> {
    public Request<CreateVolumeRequest> marshall(CreateVolumeRequest createVolumeRequest) {
        SdkInternalList createVolumeRequestTagSpecificationsList;
        if (createVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVolumeRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVolumeRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createVolumeRequest.getAvailabilityZone()));
        }
        if (createVolumeRequest.getEncrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean((Boolean)createVolumeRequest.getEncrypted()));
        }
        if (createVolumeRequest.getIops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)createVolumeRequest.getIops()));
        }
        if (createVolumeRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createVolumeRequest.getKmsKeyId()));
        }
        if (createVolumeRequest.getOutpostArn() != null) {
            request.addParameter("OutpostArn", StringUtils.fromString((String)createVolumeRequest.getOutpostArn()));
        }
        if (createVolumeRequest.getSize() != null) {
            request.addParameter("Size", StringUtils.fromInteger((Integer)createVolumeRequest.getSize()));
        }
        if (createVolumeRequest.getSnapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString((String)createVolumeRequest.getSnapshotId()));
        }
        if (createVolumeRequest.getVolumeType() != null) {
            request.addParameter("VolumeType", StringUtils.fromString((String)createVolumeRequest.getVolumeType()));
        }
        if (!(createVolumeRequestTagSpecificationsList = (SdkInternalList)createVolumeRequest.getTagSpecifications()).isEmpty() || !createVolumeRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVolumeRequestTagSpecificationsListValue : createVolumeRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createVolumeRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createVolumeRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createVolumeRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createVolumeRequest.getMultiAttachEnabled() != null) {
            request.addParameter("MultiAttachEnabled", StringUtils.fromBoolean((Boolean)createVolumeRequest.getMultiAttachEnabled()));
        }
        if (createVolumeRequest.getThroughput() != null) {
            request.addParameter("Throughput", StringUtils.fromInteger((Integer)createVolumeRequest.getThroughput()));
        }
        return request;
    }
}

