/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeKeyPairsRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeKeyPairsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeKeyPairsRequest> {
    private SdkInternalList<Filter> filters;
    private SdkInternalList<String> keyNames;
    private SdkInternalList<String> keyPairIds;

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList(filters);
    }

    public DescribeKeyPairsRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters((Collection<Filter>)new SdkInternalList(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add((Object)ele);
        }
        return this;
    }

    public DescribeKeyPairsRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public List<String> getKeyNames() {
        if (this.keyNames == null) {
            this.keyNames = new SdkInternalList();
        }
        return this.keyNames;
    }

    public void setKeyNames(Collection<String> keyNames) {
        if (keyNames == null) {
            this.keyNames = null;
            return;
        }
        this.keyNames = new SdkInternalList(keyNames);
    }

    public DescribeKeyPairsRequest withKeyNames(String ... keyNames) {
        if (this.keyNames == null) {
            this.setKeyNames((Collection<String>)new SdkInternalList(keyNames.length));
        }
        for (String ele : keyNames) {
            this.keyNames.add((Object)ele);
        }
        return this;
    }

    public DescribeKeyPairsRequest withKeyNames(Collection<String> keyNames) {
        this.setKeyNames(keyNames);
        return this;
    }

    public List<String> getKeyPairIds() {
        if (this.keyPairIds == null) {
            this.keyPairIds = new SdkInternalList();
        }
        return this.keyPairIds;
    }

    public void setKeyPairIds(Collection<String> keyPairIds) {
        if (keyPairIds == null) {
            this.keyPairIds = null;
            return;
        }
        this.keyPairIds = new SdkInternalList(keyPairIds);
    }

    public DescribeKeyPairsRequest withKeyPairIds(String ... keyPairIds) {
        if (this.keyPairIds == null) {
            this.setKeyPairIds((Collection<String>)new SdkInternalList(keyPairIds.length));
        }
        for (String ele : keyPairIds) {
            this.keyPairIds.add((Object)ele);
        }
        return this;
    }

    public DescribeKeyPairsRequest withKeyPairIds(Collection<String> keyPairIds) {
        this.setKeyPairIds(keyPairIds);
        return this;
    }

    @Override
    public Request<DescribeKeyPairsRequest> getDryRunRequest() {
        Request<DescribeKeyPairsRequest> request = new DescribeKeyPairsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getKeyNames() != null) {
            sb.append("KeyNames: ").append(this.getKeyNames()).append(",");
        }
        if (this.getKeyPairIds() != null) {
            sb.append("KeyPairIds: ").append(this.getKeyPairIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyPairsRequest)) {
            return false;
        }
        DescribeKeyPairsRequest other = (DescribeKeyPairsRequest)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getKeyNames() == null ^ this.getKeyNames() == null) {
            return false;
        }
        if (other.getKeyNames() != null && !other.getKeyNames().equals(this.getKeyNames())) {
            return false;
        }
        if (other.getKeyPairIds() == null ^ this.getKeyPairIds() == null) {
            return false;
        }
        return other.getKeyPairIds() == null || other.getKeyPairIds().equals(this.getKeyPairIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getKeyNames() == null ? 0 : this.getKeyNames().hashCode());
        hashCode = 31 * hashCode + (this.getKeyPairIds() == null ? 0 : this.getKeyPairIds().hashCode());
        return hashCode;
    }

    public DescribeKeyPairsRequest clone() {
        return (DescribeKeyPairsRequest)super.clone();
    }
}

