/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ExportImageRequest;
import com.amazonaws.services.ec2.model.ExportTaskS3LocationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class ExportImageRequestMarshaller
implements Marshaller<Request<ExportImageRequest>, ExportImageRequest> {
    public Request<ExportImageRequest> marshall(ExportImageRequest exportImageRequest) {
        ExportTaskS3LocationRequest s3ExportLocation;
        if (exportImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)exportImageRequest, "AmazonEC2");
        request.addParameter("Action", "ExportImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)exportImageRequest.getClientToken()));
        if (exportImageRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)exportImageRequest.getDescription()));
        }
        if (exportImageRequest.getDiskImageFormat() != null) {
            request.addParameter("DiskImageFormat", StringUtils.fromString((String)exportImageRequest.getDiskImageFormat()));
        }
        if (exportImageRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)exportImageRequest.getImageId()));
        }
        if ((s3ExportLocation = exportImageRequest.getS3ExportLocation()) != null) {
            if (s3ExportLocation.getS3Bucket() != null) {
                request.addParameter("S3ExportLocation.S3Bucket", StringUtils.fromString((String)s3ExportLocation.getS3Bucket()));
            }
            if (s3ExportLocation.getS3Prefix() != null) {
                request.addParameter("S3ExportLocation.S3Prefix", StringUtils.fromString((String)s3ExportLocation.getS3Prefix()));
            }
        }
        if (exportImageRequest.getRoleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)exportImageRequest.getRoleName()));
        }
        return request;
    }
}

