/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeImagesRequestMarshaller
implements Marshaller<Request<DescribeImagesRequest>, DescribeImagesRequest> {
    public Request<DescribeImagesRequest> marshall(DescribeImagesRequest describeImagesRequest) {
        SdkInternalList filtersList;
        SdkInternalList executableUsersList;
        SdkInternalList ownersList;
        if (describeImagesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeImagesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeImages");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList imageIdsList = (SdkInternalList)describeImagesRequest.getImageIds();
        if (!imageIdsList.isEmpty() || !imageIdsList.isAutoConstruct()) {
            int imageIdsListIndex = 1;
            for (String imageIdsListValue : imageIdsList) {
                if (imageIdsListValue != null) {
                    request.addParameter("ImageId." + imageIdsListIndex, StringUtils.fromString((String)imageIdsListValue));
                }
                ++imageIdsListIndex;
            }
        }
        if (!(ownersList = (SdkInternalList)describeImagesRequest.getOwners()).isEmpty() || !ownersList.isAutoConstruct()) {
            int ownersListIndex = 1;
            for (String ownersListValue : ownersList) {
                if (ownersListValue != null) {
                    request.addParameter("Owner." + ownersListIndex, StringUtils.fromString((String)ownersListValue));
                }
                ++ownersListIndex;
            }
        }
        if (!(executableUsersList = (SdkInternalList)describeImagesRequest.getExecutableUsers()).isEmpty() || !executableUsersList.isAutoConstruct()) {
            int executableUsersListIndex = 1;
            for (String executableUsersListValue : executableUsersList) {
                if (executableUsersListValue != null) {
                    request.addParameter("ExecutableBy." + executableUsersListIndex, StringUtils.fromString((String)executableUsersListValue));
                }
                ++executableUsersListIndex;
            }
        }
        if (!(filtersList = (SdkInternalList)describeImagesRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

