/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ReleaseHostsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ReleaseHostsRequestMarshaller
implements Marshaller<Request<ReleaseHostsRequest>, ReleaseHostsRequest> {
    public Request<ReleaseHostsRequest> marshall(ReleaseHostsRequest releaseHostsRequest) {
        if (releaseHostsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)releaseHostsRequest, "AmazonEC2");
        request.addParameter("Action", "ReleaseHosts");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList hostIdsList = (SdkInternalList)releaseHostsRequest.getHostIds();
        if (!hostIdsList.isEmpty() || !hostIdsList.isAutoConstruct()) {
            int hostIdsListIndex = 1;
            for (String hostIdsListValue : hostIdsList) {
                if (hostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringUtils.fromString((String)hostIdsListValue));
                }
                ++hostIdsListIndex;
            }
        }
        return request;
    }
}

