/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.ScheduledInstancesLaunchSpecification;
import com.amazonaws.services.ec2.model.transform.RunScheduledInstancesRequestMarshaller;
import java.io.Serializable;

public class RunScheduledInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<RunScheduledInstancesRequest> {
    private String clientToken;
    private Integer instanceCount;
    private String scheduledInstanceId;
    private ScheduledInstancesLaunchSpecification launchSpecification;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public RunScheduledInstancesRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public RunScheduledInstancesRequest withInstanceCount(Integer instanceCount) {
        this.setInstanceCount(instanceCount);
        return this;
    }

    public void setScheduledInstanceId(String scheduledInstanceId) {
        this.scheduledInstanceId = scheduledInstanceId;
    }

    public String getScheduledInstanceId() {
        return this.scheduledInstanceId;
    }

    public RunScheduledInstancesRequest withScheduledInstanceId(String scheduledInstanceId) {
        this.setScheduledInstanceId(scheduledInstanceId);
        return this;
    }

    public void setLaunchSpecification(ScheduledInstancesLaunchSpecification launchSpecification) {
        this.launchSpecification = launchSpecification;
    }

    public ScheduledInstancesLaunchSpecification getLaunchSpecification() {
        return this.launchSpecification;
    }

    public RunScheduledInstancesRequest withLaunchSpecification(ScheduledInstancesLaunchSpecification launchSpecification) {
        this.setLaunchSpecification(launchSpecification);
        return this;
    }

    @Override
    public Request<RunScheduledInstancesRequest> getDryRunRequest() {
        Request<RunScheduledInstancesRequest> request = new RunScheduledInstancesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: " + this.getClientToken() + ",");
        }
        if (this.getInstanceCount() != null) {
            sb.append("InstanceCount: " + this.getInstanceCount() + ",");
        }
        if (this.getScheduledInstanceId() != null) {
            sb.append("ScheduledInstanceId: " + this.getScheduledInstanceId() + ",");
        }
        if (this.getLaunchSpecification() != null) {
            sb.append("LaunchSpecification: " + this.getLaunchSpecification());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunScheduledInstancesRequest)) {
            return false;
        }
        RunScheduledInstancesRequest other = (RunScheduledInstancesRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getInstanceCount() == null ^ this.getInstanceCount() == null) {
            return false;
        }
        if (other.getInstanceCount() != null && !other.getInstanceCount().equals(this.getInstanceCount())) {
            return false;
        }
        if (other.getScheduledInstanceId() == null ^ this.getScheduledInstanceId() == null) {
            return false;
        }
        if (other.getScheduledInstanceId() != null && !other.getScheduledInstanceId().equals(this.getScheduledInstanceId())) {
            return false;
        }
        if (other.getLaunchSpecification() == null ^ this.getLaunchSpecification() == null) {
            return false;
        }
        return other.getLaunchSpecification() == null || other.getLaunchSpecification().equals(this.getLaunchSpecification());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCount() == null ? 0 : this.getInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getScheduledInstanceId() == null ? 0 : this.getScheduledInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchSpecification() == null ? 0 : this.getLaunchSpecification().hashCode());
        return hashCode;
    }

    public RunScheduledInstancesRequest clone() {
        return (RunScheduledInstancesRequest)super.clone();
    }
}

