/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.Protocol;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.endpoints.AccountIdEndpointMode;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.dynamodbv2.util.ResourceNameUtils;
import com.amazonaws.util.SdkUri;
import com.amazonaws.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccountEndpointOverrideRequestHandler
extends RequestHandler2 {
    private static final String COMMERCIAL_PARTITION = "aws";
    private static final String ENDPOINT_FORMAT = "%s://%s.ddb.%s.%s";
    private static final Log LOG = LogFactory.getLog(AccountEndpointOverrideRequestHandler.class);
    private static final String DEFAULT_PROTOCOL = "https";
    static final String DYNAMODB_SERVICE_NAME = "AmazonDynamoDBv2";

    public void beforeRequest(Request<?> request) {
        block8: {
            AccountIdEndpointMode endpointMode = null;
            try {
                if (!this.isDdbRequest(request)) {
                    return;
                }
                endpointMode = (AccountIdEndpointMode)request.getHandlerContext(HandlerContextKey.ACCOUNT_ID_ENDPOINT_MODE);
                Boolean isEndpointOverridden = (Boolean)request.getHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN);
                if (endpointMode == AccountIdEndpointMode.DISABLED || isEndpointOverridden != null && isEndpointOverridden.booleanValue()) {
                    return;
                }
                String regionName = (String)request.getHandlerContext(HandlerContextKey.SIGNING_REGION);
                Region regionObj = RegionUtils.getRegion((String)regionName);
                if (StringUtils.isNullOrEmpty((String)regionName) || regionObj == null) {
                    this.handleMissingRegion();
                    return;
                }
                if (!this.isCommercialRegion(regionObj)) {
                    return;
                }
                String resolvedAccountId = this.getAccountId(request, regionName);
                if (StringUtils.isNullOrEmpty((String)resolvedAccountId)) {
                    this.handleMissingAccountId(endpointMode);
                    return;
                }
                Protocol clientProtocol = (Protocol)request.getHandlerContext(HandlerContextKey.CLIENT_PROTOCOL);
                String protocol = Protocol.HTTP == clientProtocol ? clientProtocol.toString() : DEFAULT_PROTOCOL;
                String accountEndpoint = String.format(ENDPOINT_FORMAT, protocol, resolvedAccountId, regionName, regionObj.getDomain());
                request.setEndpoint(SdkUri.getInstance().create(accountEndpoint));
            }
            catch (Exception e) {
                if (endpointMode == AccountIdEndpointMode.REQUIRED) {
                    throw e;
                }
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)"Exception encountered while setting endpoint based on accountId endpoint mode, skipping", (Throwable)e);
            }
        }
    }

    private boolean isDdbRequest(Request<?> request) {
        return DYNAMODB_SERVICE_NAME.equals(request.getServiceName());
    }

    private void handleMissingAccountId(AccountIdEndpointMode endpointMode) {
        if (endpointMode == AccountIdEndpointMode.REQUIRED) {
            throw new SdkClientException(this.unableToConstructEndpointMessage("AccountIdEndpointMode is REQUIRED but no account ID was provided or able to be loaded."));
        }
    }

    private void handleMissingRegion() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.unableToConstructEndpointMessage("Region could not be found or derived from the metadata."));
        }
    }

    private boolean isCommercialRegion(Region regionObj) {
        return COMMERCIAL_PARTITION.equals(regionObj.getPartition());
    }

    private String unableToConstructEndpointMessage(String reason) {
        return "Cannot construct account ID based endpoint. " + reason;
    }

    protected String getAccountId(Request<?> request, String regionName) {
        String accountIdFromRequest = ResourceNameUtils.getAccountIdFromTableArnInRequest(request, regionName, COMMERCIAL_PARTITION);
        if (!StringUtils.isNullOrEmpty((String)accountIdFromRequest)) {
            return accountIdFromRequest;
        }
        return (String)request.getHandlerContext(HandlerContextKey.AWS_CREDENTIALS_ACCOUNT_ID);
    }
}

