/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devopsguru.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.ServiceCollection;
import java.util.List;

@SdkInternalApi
public class ServiceCollectionMarshaller {
    private static final MarshallingInfo<List> SERVICENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceNames").build();
    private static final ServiceCollectionMarshaller instance = new ServiceCollectionMarshaller();

    public static ServiceCollectionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ServiceCollection serviceCollection, ProtocolMarshaller protocolMarshaller) {
        if (serviceCollection == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(serviceCollection.getServiceNames(), SERVICENAMES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

