/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.ImmutableMapParameter;
import com.amazonaws.util.json.SdkJsonGenerator;
import com.amazonaws.util.json.SdkStructuredJsonFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import com.fasterxml.jackson.core.JsonFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
class SdkStructuredPlainJsonFactory
implements SdkStructuredJsonFactory {
    public static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final String CONTENT_TYPE_JSON_PREFIX = "application/x-amz-json-";
    public static final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> JSON_SCALAR_UNMARSHALLERS = new ImmutableMapParameter.Builder<Class<String>, SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller>().put(String.class, SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance()).put(Double.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.DoubleJsonUnmarshaller.getInstance())).put(Integer.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.IntegerJsonUnmarshaller.getInstance())).put(BigInteger.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.BigIntegerJsonUnmarshaller.getInstance())).put(BigDecimal.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.BigDecimalJsonUnmarshaller.getInstance())).put(Boolean.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance())).put(Float.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.FloatJsonUnmarshaller.getInstance())).put(Long.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.LongJsonUnmarshaller.getInstance())).put(Byte.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.ByteJsonUnmarshaller.getInstance())).put(Date.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance())).put(ByteBuffer.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.ByteBufferJsonUnmarshaller.getInstance())).put(Character.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.CharacterJsonUnmarshaller.getInstance())).put(Short.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.ShortJsonUnmarshaller.getInstance())).build();

    SdkStructuredPlainJsonFactory() {
    }

    @Override
    public StructuredJsonGenerator createWriter(String protocolVersion) {
        return new SdkJsonGenerator(JSON_FACTORY, CONTENT_TYPE_JSON_PREFIX + protocolVersion);
    }

    @Override
    public JsonResponseHandler createResponseHandler(Unmarshaller<?, JsonUnmarshallerContext> responseUnmarshaller) {
        return new JsonResponseHandler(responseUnmarshaller, JSON_SCALAR_UNMARSHALLERS, JSON_FACTORY);
    }

    @Override
    public JsonErrorResponseHandlerV2 createErrorResponseHandler(List<JsonErrorUnmarshallerV2> errorUnmarshallers) {
        return new JsonErrorResponseHandlerV2(errorUnmarshallers, JSON_FACTORY);
    }
}

