/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.retry.RetryUtils;
import java.io.IOException;
import java.util.Random;

public class PredefinedRetryPolicies {
    public static final RetryPolicy NO_RETRY_POLICY = new RetryPolicy(RetryPolicy.RetryCondition.NO_RETRY_CONDITION, RetryPolicy.BackoffStrategy.NO_DELAY, 0, false);
    public static final int DEFAULT_MAX_ERROR_RETRY = 3;
    public static final RetryPolicy DEFAULT;
    public static final int DYNAMODB_DEFAULT_MAX_ERROR_RETRY = 10;
    public static final RetryPolicy DYNAMODB_DEFAULT;
    public static final RetryPolicy.RetryCondition DEFAULT_RETRY_CONDITION;
    public static final RetryPolicy.BackoffStrategy DEFAULT_BACKOFF_STRATEGY;
    public static final RetryPolicy.BackoffStrategy DYNAMODB_DEFAULT_BACKOFF_STRATEGY;

    public static RetryPolicy getDefaultRetryPolicy() {
        return new RetryPolicy(DEFAULT_RETRY_CONDITION, DEFAULT_BACKOFF_STRATEGY, 3, true);
    }

    public static RetryPolicy getDynamoDBDefaultRetryPolicy() {
        return new RetryPolicy(DEFAULT_RETRY_CONDITION, DYNAMODB_DEFAULT_BACKOFF_STRATEGY, 10, true);
    }

    public static RetryPolicy getDefaultRetryPolicyWithCustomMaxRetries(int maxErrorRetry) {
        return new RetryPolicy(DEFAULT_RETRY_CONDITION, DEFAULT_BACKOFF_STRATEGY, maxErrorRetry, false);
    }

    public static RetryPolicy getDynamoDBDefaultRetryPolicyWithCustomMaxRetries(int maxErrorRetry) {
        return new RetryPolicy(DEFAULT_RETRY_CONDITION, DYNAMODB_DEFAULT_BACKOFF_STRATEGY, maxErrorRetry, false);
    }

    static {
        DEFAULT_RETRY_CONDITION = new SDKDefaultRetryCondition();
        DEFAULT_BACKOFF_STRATEGY = new SDKDefaultBackoffStrategy();
        DYNAMODB_DEFAULT_BACKOFF_STRATEGY = new DynamoDBDefaultBackoffStrategy();
        DEFAULT = PredefinedRetryPolicies.getDefaultRetryPolicy();
        DYNAMODB_DEFAULT = PredefinedRetryPolicies.getDynamoDBDefaultRetryPolicy();
    }

    private static class DynamoDBDefaultBackoffStrategy
    implements RetryPolicy.BackoffStrategy {
        private static final int SCALE_FACTOR = 25;
        private static final int MAX_BACKOFF_IN_MILLISECONDS = 20000;
        private static final int MAX_RETRIES_BEFORE_MAX_BACKOFF = 9;

        private DynamoDBDefaultBackoffStrategy() {
        }

        @Override
        public final long delayBeforeNextRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
            if (retriesAttempted < 0) {
                return 0L;
            }
            if (retriesAttempted > 9) {
                return 20000L;
            }
            long delay = (1L << retriesAttempted) * 25L;
            delay = Math.min(delay, 20000L);
            return delay;
        }
    }

    private static class SDKDefaultBackoffStrategy
    implements RetryPolicy.BackoffStrategy {
        private static final int SCALE_FACTOR = 300;
        private static final int THROTTLING_SCALE_FACTOR = 500;
        private static final int THROTTLING_SCALE_FACTOR_RANDOM_RANGE = 125;
        private static final int MAX_BACKOFF_IN_MILLISECONDS = 20000;
        private static final int MAX_RETRIES_BEFORE_MAX_BACKOFF = 6;
        private final Random random = new Random();

        private SDKDefaultBackoffStrategy() {
        }

        @Override
        public final long delayBeforeNextRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
            if (retriesAttempted < 0) {
                return 0L;
            }
            if (retriesAttempted > 6) {
                return 20000L;
            }
            int scaleFactor = exception instanceof AmazonServiceException && RetryUtils.isThrottlingException((AmazonServiceException)exception) ? 500 + this.random.nextInt(125) : 300;
            long delay = (1L << retriesAttempted) * (long)scaleFactor;
            delay = Math.min(delay, 20000L);
            return delay;
        }
    }

    public static class SDKDefaultRetryCondition
    implements RetryPolicy.RetryCondition {
        @Override
        public boolean shouldRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
            if (exception.getCause() instanceof IOException) {
                return true;
            }
            if (exception instanceof AmazonServiceException) {
                AmazonServiceException ase = (AmazonServiceException)exception;
                if (RetryUtils.isRetryableServiceException(ase)) {
                    return true;
                }
                if (RetryUtils.isThrottlingException(ase)) {
                    return true;
                }
                if (RetryUtils.isClockSkewError(ase)) {
                    return true;
                }
            }
            return false;
        }
    }
}

