/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.config.AmazonConfigAsync;
import com.amazonaws.services.config.AmazonConfigAsyncClientBuilder;
import com.amazonaws.services.config.AmazonConfigClient;
import com.amazonaws.services.config.model.DeleteConfigRuleRequest;
import com.amazonaws.services.config.model.DeleteConfigRuleResult;
import com.amazonaws.services.config.model.DeleteConfigurationRecorderRequest;
import com.amazonaws.services.config.model.DeleteConfigurationRecorderResult;
import com.amazonaws.services.config.model.DeleteDeliveryChannelRequest;
import com.amazonaws.services.config.model.DeleteDeliveryChannelResult;
import com.amazonaws.services.config.model.DeleteEvaluationResultsRequest;
import com.amazonaws.services.config.model.DeleteEvaluationResultsResult;
import com.amazonaws.services.config.model.DeliverConfigSnapshotRequest;
import com.amazonaws.services.config.model.DeliverConfigSnapshotResult;
import com.amazonaws.services.config.model.DescribeComplianceByConfigRuleRequest;
import com.amazonaws.services.config.model.DescribeComplianceByConfigRuleResult;
import com.amazonaws.services.config.model.DescribeComplianceByResourceRequest;
import com.amazonaws.services.config.model.DescribeComplianceByResourceResult;
import com.amazonaws.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import com.amazonaws.services.config.model.DescribeConfigRuleEvaluationStatusResult;
import com.amazonaws.services.config.model.DescribeConfigRulesRequest;
import com.amazonaws.services.config.model.DescribeConfigRulesResult;
import com.amazonaws.services.config.model.DescribeConfigurationRecorderStatusRequest;
import com.amazonaws.services.config.model.DescribeConfigurationRecorderStatusResult;
import com.amazonaws.services.config.model.DescribeConfigurationRecordersRequest;
import com.amazonaws.services.config.model.DescribeConfigurationRecordersResult;
import com.amazonaws.services.config.model.DescribeDeliveryChannelStatusRequest;
import com.amazonaws.services.config.model.DescribeDeliveryChannelStatusResult;
import com.amazonaws.services.config.model.DescribeDeliveryChannelsRequest;
import com.amazonaws.services.config.model.DescribeDeliveryChannelsResult;
import com.amazonaws.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import com.amazonaws.services.config.model.GetComplianceDetailsByConfigRuleResult;
import com.amazonaws.services.config.model.GetComplianceDetailsByResourceRequest;
import com.amazonaws.services.config.model.GetComplianceDetailsByResourceResult;
import com.amazonaws.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import com.amazonaws.services.config.model.GetComplianceSummaryByConfigRuleResult;
import com.amazonaws.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import com.amazonaws.services.config.model.GetComplianceSummaryByResourceTypeResult;
import com.amazonaws.services.config.model.GetResourceConfigHistoryRequest;
import com.amazonaws.services.config.model.GetResourceConfigHistoryResult;
import com.amazonaws.services.config.model.ListDiscoveredResourcesRequest;
import com.amazonaws.services.config.model.ListDiscoveredResourcesResult;
import com.amazonaws.services.config.model.PutConfigRuleRequest;
import com.amazonaws.services.config.model.PutConfigRuleResult;
import com.amazonaws.services.config.model.PutConfigurationRecorderRequest;
import com.amazonaws.services.config.model.PutConfigurationRecorderResult;
import com.amazonaws.services.config.model.PutDeliveryChannelRequest;
import com.amazonaws.services.config.model.PutDeliveryChannelResult;
import com.amazonaws.services.config.model.PutEvaluationsRequest;
import com.amazonaws.services.config.model.PutEvaluationsResult;
import com.amazonaws.services.config.model.StartConfigRulesEvaluationRequest;
import com.amazonaws.services.config.model.StartConfigRulesEvaluationResult;
import com.amazonaws.services.config.model.StartConfigurationRecorderRequest;
import com.amazonaws.services.config.model.StartConfigurationRecorderResult;
import com.amazonaws.services.config.model.StopConfigurationRecorderRequest;
import com.amazonaws.services.config.model.StopConfigurationRecorderResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonConfigAsyncClient
extends AmazonConfigClient
implements AmazonConfigAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonConfigAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonConfigAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonConfigAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonConfigAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonConfigAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonConfigAsyncClientBuilder asyncBuilder() {
        return AmazonConfigAsyncClientBuilder.standard();
    }

    AmazonConfigAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteConfigRuleResult> deleteConfigRuleAsync(DeleteConfigRuleRequest request) {
        return this.deleteConfigRuleAsync(request, null);
    }

    @Override
    public Future<DeleteConfigRuleResult> deleteConfigRuleAsync(DeleteConfigRuleRequest request, final AsyncHandler<DeleteConfigRuleRequest, DeleteConfigRuleResult> asyncHandler) {
        final DeleteConfigRuleRequest finalRequest = (DeleteConfigRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteConfigRuleResult>(){

            @Override
            public DeleteConfigRuleResult call() throws Exception {
                DeleteConfigRuleResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeDeleteConfigRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteConfigurationRecorderResult> deleteConfigurationRecorderAsync(DeleteConfigurationRecorderRequest request) {
        return this.deleteConfigurationRecorderAsync(request, null);
    }

    @Override
    public Future<DeleteConfigurationRecorderResult> deleteConfigurationRecorderAsync(DeleteConfigurationRecorderRequest request, final AsyncHandler<DeleteConfigurationRecorderRequest, DeleteConfigurationRecorderResult> asyncHandler) {
        final DeleteConfigurationRecorderRequest finalRequest = (DeleteConfigurationRecorderRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteConfigurationRecorderResult>(){

            @Override
            public DeleteConfigurationRecorderResult call() throws Exception {
                DeleteConfigurationRecorderResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeDeleteConfigurationRecorder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDeliveryChannelResult> deleteDeliveryChannelAsync(DeleteDeliveryChannelRequest request) {
        return this.deleteDeliveryChannelAsync(request, null);
    }

    @Override
    public Future<DeleteDeliveryChannelResult> deleteDeliveryChannelAsync(DeleteDeliveryChannelRequest request, final AsyncHandler<DeleteDeliveryChannelRequest, DeleteDeliveryChannelResult> asyncHandler) {
        final DeleteDeliveryChannelRequest finalRequest = (DeleteDeliveryChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDeliveryChannelResult>(){

            @Override
            public DeleteDeliveryChannelResult call() throws Exception {
                DeleteDeliveryChannelResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeDeleteDeliveryChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEvaluationResultsResult> deleteEvaluationResultsAsync(DeleteEvaluationResultsRequest request) {
        return this.deleteEvaluationResultsAsync(request, null);
    }

    @Override
    public Future<DeleteEvaluationResultsResult> deleteEvaluationResultsAsync(DeleteEvaluationResultsRequest request, final AsyncHandler<DeleteEvaluationResultsRequest, DeleteEvaluationResultsResult> asyncHandler) {
        final DeleteEvaluationResultsRequest finalRequest = (DeleteEvaluationResultsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEvaluationResultsResult>(){

            @Override
            public DeleteEvaluationResultsResult call() throws Exception {
                DeleteEvaluationResultsResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeDeleteEvaluationResults(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeliverConfigSnapshotResult> deliverConfigSnapshotAsync(DeliverConfigSnapshotRequest request) {
        return this.deliverConfigSnapshotAsync(request, null);
    }

    @Override
    public Future<DeliverConfigSnapshotResult> deliverConfigSnapshotAsync(DeliverConfigSnapshotRequest request, final AsyncHandler<DeliverConfigSnapshotRequest, DeliverConfigSnapshotResult> asyncHandler) {
        final DeliverConfigSnapshotRequest finalRequest = (DeliverConfigSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeliverConfigSnapshotResult>(){

            @Override
            public DeliverConfigSnapshotResult call() throws Exception {
                DeliverConfigSnapshotResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeDeliverConfigSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeComplianceByConfigRuleResult> describeComplianceByConfigRuleAsync(DescribeComplianceByConfigRuleRequest request) {
        return this.describeComplianceByConfigRuleAsync(request, null);
    }

    @Override
    public Future<DescribeComplianceByConfigRuleResult> describeComplianceByConfigRuleAsync(DescribeComplianceByConfigRuleRequest request, final AsyncHandler<DescribeComplianceByConfigRuleRequest, DescribeComplianceByConfigRuleResult> asyncHandler) {
        final DescribeComplianceByConfigRuleRequest finalRequest = (DescribeComplianceByConfigRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeComplianceByConfigRuleResult>(){

            @Override
            public DescribeComplianceByConfigRuleResult call() throws Exception {
                DescribeComplianceByConfigRuleResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeDescribeComplianceByConfigRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeComplianceByConfigRuleResult> describeComplianceByConfigRuleAsync() {
        return this.describeComplianceByConfigRuleAsync(new DescribeComplianceByConfigRuleRequest());
    }

    @Override
    public Future<DescribeComplianceByConfigRuleResult> describeComplianceByConfigRuleAsync(AsyncHandler<DescribeComplianceByConfigRuleRequest, DescribeComplianceByConfigRuleResult> asyncHandler) {
        return this.describeComplianceByConfigRuleAsync(new DescribeComplianceByConfigRuleRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeComplianceByResourceResult> describeComplianceByResourceAsync(DescribeComplianceByResourceRequest request) {
        return this.describeComplianceByResourceAsync(request, null);
    }

    @Override
    public Future<DescribeComplianceByResourceResult> describeComplianceByResourceAsync(DescribeComplianceByResourceRequest request, final AsyncHandler<DescribeComplianceByResourceRequest, DescribeComplianceByResourceResult> asyncHandler) {
        final DescribeComplianceByResourceRequest finalRequest = (DescribeComplianceByResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeComplianceByResourceResult>(){

            @Override
            public DescribeComplianceByResourceResult call() throws Exception {
                DescribeComplianceByResourceResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeDescribeComplianceByResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeComplianceByResourceResult> describeComplianceByResourceAsync() {
        return this.describeComplianceByResourceAsync(new DescribeComplianceByResourceRequest());
    }

    @Override
    public Future<DescribeComplianceByResourceResult> describeComplianceByResourceAsync(AsyncHandler<DescribeComplianceByResourceRequest, DescribeComplianceByResourceResult> asyncHandler) {
        return this.describeComplianceByResourceAsync(new DescribeComplianceByResourceRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeConfigRuleEvaluationStatusResult> describeConfigRuleEvaluationStatusAsync(DescribeConfigRuleEvaluationStatusRequest request) {
        return this.describeConfigRuleEvaluationStatusAsync(request, null);
    }

    @Override
    public Future<DescribeConfigRuleEvaluationStatusResult> describeConfigRuleEvaluationStatusAsync(DescribeConfigRuleEvaluationStatusRequest request, final AsyncHandler<DescribeConfigRuleEvaluationStatusRequest, DescribeConfigRuleEvaluationStatusResult> asyncHandler) {
        final DescribeConfigRuleEvaluationStatusRequest finalRequest = (DescribeConfigRuleEvaluationStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConfigRuleEvaluationStatusResult>(){

            @Override
            public DescribeConfigRuleEvaluationStatusResult call() throws Exception {
                DescribeConfigRuleEvaluationStatusResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeDescribeConfigRuleEvaluationStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigRuleEvaluationStatusResult> describeConfigRuleEvaluationStatusAsync() {
        return this.describeConfigRuleEvaluationStatusAsync(new DescribeConfigRuleEvaluationStatusRequest());
    }

    @Override
    public Future<DescribeConfigRuleEvaluationStatusResult> describeConfigRuleEvaluationStatusAsync(AsyncHandler<DescribeConfigRuleEvaluationStatusRequest, DescribeConfigRuleEvaluationStatusResult> asyncHandler) {
        return this.describeConfigRuleEvaluationStatusAsync(new DescribeConfigRuleEvaluationStatusRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeConfigRulesResult> describeConfigRulesAsync(DescribeConfigRulesRequest request) {
        return this.describeConfigRulesAsync(request, null);
    }

    @Override
    public Future<DescribeConfigRulesResult> describeConfigRulesAsync(DescribeConfigRulesRequest request, final AsyncHandler<DescribeConfigRulesRequest, DescribeConfigRulesResult> asyncHandler) {
        final DescribeConfigRulesRequest finalRequest = (DescribeConfigRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConfigRulesResult>(){

            @Override
            public DescribeConfigRulesResult call() throws Exception {
                DescribeConfigRulesResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeDescribeConfigRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigRulesResult> describeConfigRulesAsync() {
        return this.describeConfigRulesAsync(new DescribeConfigRulesRequest());
    }

    @Override
    public Future<DescribeConfigRulesResult> describeConfigRulesAsync(AsyncHandler<DescribeConfigRulesRequest, DescribeConfigRulesResult> asyncHandler) {
        return this.describeConfigRulesAsync(new DescribeConfigRulesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeConfigurationRecorderStatusResult> describeConfigurationRecorderStatusAsync(DescribeConfigurationRecorderStatusRequest request) {
        return this.describeConfigurationRecorderStatusAsync(request, null);
    }

    @Override
    public Future<DescribeConfigurationRecorderStatusResult> describeConfigurationRecorderStatusAsync(DescribeConfigurationRecorderStatusRequest request, final AsyncHandler<DescribeConfigurationRecorderStatusRequest, DescribeConfigurationRecorderStatusResult> asyncHandler) {
        final DescribeConfigurationRecorderStatusRequest finalRequest = (DescribeConfigurationRecorderStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConfigurationRecorderStatusResult>(){

            @Override
            public DescribeConfigurationRecorderStatusResult call() throws Exception {
                DescribeConfigurationRecorderStatusResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeDescribeConfigurationRecorderStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationRecorderStatusResult> describeConfigurationRecorderStatusAsync() {
        return this.describeConfigurationRecorderStatusAsync(new DescribeConfigurationRecorderStatusRequest());
    }

    @Override
    public Future<DescribeConfigurationRecorderStatusResult> describeConfigurationRecorderStatusAsync(AsyncHandler<DescribeConfigurationRecorderStatusRequest, DescribeConfigurationRecorderStatusResult> asyncHandler) {
        return this.describeConfigurationRecorderStatusAsync(new DescribeConfigurationRecorderStatusRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeConfigurationRecordersResult> describeConfigurationRecordersAsync(DescribeConfigurationRecordersRequest request) {
        return this.describeConfigurationRecordersAsync(request, null);
    }

    @Override
    public Future<DescribeConfigurationRecordersResult> describeConfigurationRecordersAsync(DescribeConfigurationRecordersRequest request, final AsyncHandler<DescribeConfigurationRecordersRequest, DescribeConfigurationRecordersResult> asyncHandler) {
        final DescribeConfigurationRecordersRequest finalRequest = (DescribeConfigurationRecordersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConfigurationRecordersResult>(){

            @Override
            public DescribeConfigurationRecordersResult call() throws Exception {
                DescribeConfigurationRecordersResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeDescribeConfigurationRecorders(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationRecordersResult> describeConfigurationRecordersAsync() {
        return this.describeConfigurationRecordersAsync(new DescribeConfigurationRecordersRequest());
    }

    @Override
    public Future<DescribeConfigurationRecordersResult> describeConfigurationRecordersAsync(AsyncHandler<DescribeConfigurationRecordersRequest, DescribeConfigurationRecordersResult> asyncHandler) {
        return this.describeConfigurationRecordersAsync(new DescribeConfigurationRecordersRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDeliveryChannelStatusResult> describeDeliveryChannelStatusAsync(DescribeDeliveryChannelStatusRequest request) {
        return this.describeDeliveryChannelStatusAsync(request, null);
    }

    @Override
    public Future<DescribeDeliveryChannelStatusResult> describeDeliveryChannelStatusAsync(DescribeDeliveryChannelStatusRequest request, final AsyncHandler<DescribeDeliveryChannelStatusRequest, DescribeDeliveryChannelStatusResult> asyncHandler) {
        final DescribeDeliveryChannelStatusRequest finalRequest = (DescribeDeliveryChannelStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDeliveryChannelStatusResult>(){

            @Override
            public DescribeDeliveryChannelStatusResult call() throws Exception {
                DescribeDeliveryChannelStatusResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeDescribeDeliveryChannelStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeliveryChannelStatusResult> describeDeliveryChannelStatusAsync() {
        return this.describeDeliveryChannelStatusAsync(new DescribeDeliveryChannelStatusRequest());
    }

    @Override
    public Future<DescribeDeliveryChannelStatusResult> describeDeliveryChannelStatusAsync(AsyncHandler<DescribeDeliveryChannelStatusRequest, DescribeDeliveryChannelStatusResult> asyncHandler) {
        return this.describeDeliveryChannelStatusAsync(new DescribeDeliveryChannelStatusRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDeliveryChannelsResult> describeDeliveryChannelsAsync(DescribeDeliveryChannelsRequest request) {
        return this.describeDeliveryChannelsAsync(request, null);
    }

    @Override
    public Future<DescribeDeliveryChannelsResult> describeDeliveryChannelsAsync(DescribeDeliveryChannelsRequest request, final AsyncHandler<DescribeDeliveryChannelsRequest, DescribeDeliveryChannelsResult> asyncHandler) {
        final DescribeDeliveryChannelsRequest finalRequest = (DescribeDeliveryChannelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDeliveryChannelsResult>(){

            @Override
            public DescribeDeliveryChannelsResult call() throws Exception {
                DescribeDeliveryChannelsResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeDescribeDeliveryChannels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeliveryChannelsResult> describeDeliveryChannelsAsync() {
        return this.describeDeliveryChannelsAsync(new DescribeDeliveryChannelsRequest());
    }

    @Override
    public Future<DescribeDeliveryChannelsResult> describeDeliveryChannelsAsync(AsyncHandler<DescribeDeliveryChannelsRequest, DescribeDeliveryChannelsResult> asyncHandler) {
        return this.describeDeliveryChannelsAsync(new DescribeDeliveryChannelsRequest(), asyncHandler);
    }

    @Override
    public Future<GetComplianceDetailsByConfigRuleResult> getComplianceDetailsByConfigRuleAsync(GetComplianceDetailsByConfigRuleRequest request) {
        return this.getComplianceDetailsByConfigRuleAsync(request, null);
    }

    @Override
    public Future<GetComplianceDetailsByConfigRuleResult> getComplianceDetailsByConfigRuleAsync(GetComplianceDetailsByConfigRuleRequest request, final AsyncHandler<GetComplianceDetailsByConfigRuleRequest, GetComplianceDetailsByConfigRuleResult> asyncHandler) {
        final GetComplianceDetailsByConfigRuleRequest finalRequest = (GetComplianceDetailsByConfigRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetComplianceDetailsByConfigRuleResult>(){

            @Override
            public GetComplianceDetailsByConfigRuleResult call() throws Exception {
                GetComplianceDetailsByConfigRuleResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeGetComplianceDetailsByConfigRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetComplianceDetailsByResourceResult> getComplianceDetailsByResourceAsync(GetComplianceDetailsByResourceRequest request) {
        return this.getComplianceDetailsByResourceAsync(request, null);
    }

    @Override
    public Future<GetComplianceDetailsByResourceResult> getComplianceDetailsByResourceAsync(GetComplianceDetailsByResourceRequest request, final AsyncHandler<GetComplianceDetailsByResourceRequest, GetComplianceDetailsByResourceResult> asyncHandler) {
        final GetComplianceDetailsByResourceRequest finalRequest = (GetComplianceDetailsByResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetComplianceDetailsByResourceResult>(){

            @Override
            public GetComplianceDetailsByResourceResult call() throws Exception {
                GetComplianceDetailsByResourceResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeGetComplianceDetailsByResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetComplianceSummaryByConfigRuleResult> getComplianceSummaryByConfigRuleAsync(GetComplianceSummaryByConfigRuleRequest request) {
        return this.getComplianceSummaryByConfigRuleAsync(request, null);
    }

    @Override
    public Future<GetComplianceSummaryByConfigRuleResult> getComplianceSummaryByConfigRuleAsync(GetComplianceSummaryByConfigRuleRequest request, final AsyncHandler<GetComplianceSummaryByConfigRuleRequest, GetComplianceSummaryByConfigRuleResult> asyncHandler) {
        final GetComplianceSummaryByConfigRuleRequest finalRequest = (GetComplianceSummaryByConfigRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetComplianceSummaryByConfigRuleResult>(){

            @Override
            public GetComplianceSummaryByConfigRuleResult call() throws Exception {
                GetComplianceSummaryByConfigRuleResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeGetComplianceSummaryByConfigRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetComplianceSummaryByConfigRuleResult> getComplianceSummaryByConfigRuleAsync() {
        return this.getComplianceSummaryByConfigRuleAsync(new GetComplianceSummaryByConfigRuleRequest());
    }

    @Override
    public Future<GetComplianceSummaryByConfigRuleResult> getComplianceSummaryByConfigRuleAsync(AsyncHandler<GetComplianceSummaryByConfigRuleRequest, GetComplianceSummaryByConfigRuleResult> asyncHandler) {
        return this.getComplianceSummaryByConfigRuleAsync(new GetComplianceSummaryByConfigRuleRequest(), asyncHandler);
    }

    @Override
    public Future<GetComplianceSummaryByResourceTypeResult> getComplianceSummaryByResourceTypeAsync(GetComplianceSummaryByResourceTypeRequest request) {
        return this.getComplianceSummaryByResourceTypeAsync(request, null);
    }

    @Override
    public Future<GetComplianceSummaryByResourceTypeResult> getComplianceSummaryByResourceTypeAsync(GetComplianceSummaryByResourceTypeRequest request, final AsyncHandler<GetComplianceSummaryByResourceTypeRequest, GetComplianceSummaryByResourceTypeResult> asyncHandler) {
        final GetComplianceSummaryByResourceTypeRequest finalRequest = (GetComplianceSummaryByResourceTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetComplianceSummaryByResourceTypeResult>(){

            @Override
            public GetComplianceSummaryByResourceTypeResult call() throws Exception {
                GetComplianceSummaryByResourceTypeResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeGetComplianceSummaryByResourceType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetComplianceSummaryByResourceTypeResult> getComplianceSummaryByResourceTypeAsync() {
        return this.getComplianceSummaryByResourceTypeAsync(new GetComplianceSummaryByResourceTypeRequest());
    }

    @Override
    public Future<GetComplianceSummaryByResourceTypeResult> getComplianceSummaryByResourceTypeAsync(AsyncHandler<GetComplianceSummaryByResourceTypeRequest, GetComplianceSummaryByResourceTypeResult> asyncHandler) {
        return this.getComplianceSummaryByResourceTypeAsync(new GetComplianceSummaryByResourceTypeRequest(), asyncHandler);
    }

    @Override
    public Future<GetResourceConfigHistoryResult> getResourceConfigHistoryAsync(GetResourceConfigHistoryRequest request) {
        return this.getResourceConfigHistoryAsync(request, null);
    }

    @Override
    public Future<GetResourceConfigHistoryResult> getResourceConfigHistoryAsync(GetResourceConfigHistoryRequest request, final AsyncHandler<GetResourceConfigHistoryRequest, GetResourceConfigHistoryResult> asyncHandler) {
        final GetResourceConfigHistoryRequest finalRequest = (GetResourceConfigHistoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourceConfigHistoryResult>(){

            @Override
            public GetResourceConfigHistoryResult call() throws Exception {
                GetResourceConfigHistoryResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeGetResourceConfigHistory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDiscoveredResourcesResult> listDiscoveredResourcesAsync(ListDiscoveredResourcesRequest request) {
        return this.listDiscoveredResourcesAsync(request, null);
    }

    @Override
    public Future<ListDiscoveredResourcesResult> listDiscoveredResourcesAsync(ListDiscoveredResourcesRequest request, final AsyncHandler<ListDiscoveredResourcesRequest, ListDiscoveredResourcesResult> asyncHandler) {
        final ListDiscoveredResourcesRequest finalRequest = (ListDiscoveredResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDiscoveredResourcesResult>(){

            @Override
            public ListDiscoveredResourcesResult call() throws Exception {
                ListDiscoveredResourcesResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeListDiscoveredResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutConfigRuleResult> putConfigRuleAsync(PutConfigRuleRequest request) {
        return this.putConfigRuleAsync(request, null);
    }

    @Override
    public Future<PutConfigRuleResult> putConfigRuleAsync(PutConfigRuleRequest request, final AsyncHandler<PutConfigRuleRequest, PutConfigRuleResult> asyncHandler) {
        final PutConfigRuleRequest finalRequest = (PutConfigRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutConfigRuleResult>(){

            @Override
            public PutConfigRuleResult call() throws Exception {
                PutConfigRuleResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executePutConfigRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutConfigurationRecorderResult> putConfigurationRecorderAsync(PutConfigurationRecorderRequest request) {
        return this.putConfigurationRecorderAsync(request, null);
    }

    @Override
    public Future<PutConfigurationRecorderResult> putConfigurationRecorderAsync(PutConfigurationRecorderRequest request, final AsyncHandler<PutConfigurationRecorderRequest, PutConfigurationRecorderResult> asyncHandler) {
        final PutConfigurationRecorderRequest finalRequest = (PutConfigurationRecorderRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutConfigurationRecorderResult>(){

            @Override
            public PutConfigurationRecorderResult call() throws Exception {
                PutConfigurationRecorderResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executePutConfigurationRecorder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutDeliveryChannelResult> putDeliveryChannelAsync(PutDeliveryChannelRequest request) {
        return this.putDeliveryChannelAsync(request, null);
    }

    @Override
    public Future<PutDeliveryChannelResult> putDeliveryChannelAsync(PutDeliveryChannelRequest request, final AsyncHandler<PutDeliveryChannelRequest, PutDeliveryChannelResult> asyncHandler) {
        final PutDeliveryChannelRequest finalRequest = (PutDeliveryChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutDeliveryChannelResult>(){

            @Override
            public PutDeliveryChannelResult call() throws Exception {
                PutDeliveryChannelResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executePutDeliveryChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutEvaluationsResult> putEvaluationsAsync(PutEvaluationsRequest request) {
        return this.putEvaluationsAsync(request, null);
    }

    @Override
    public Future<PutEvaluationsResult> putEvaluationsAsync(PutEvaluationsRequest request, final AsyncHandler<PutEvaluationsRequest, PutEvaluationsResult> asyncHandler) {
        final PutEvaluationsRequest finalRequest = (PutEvaluationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutEvaluationsResult>(){

            @Override
            public PutEvaluationsResult call() throws Exception {
                PutEvaluationsResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executePutEvaluations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartConfigRulesEvaluationResult> startConfigRulesEvaluationAsync(StartConfigRulesEvaluationRequest request) {
        return this.startConfigRulesEvaluationAsync(request, null);
    }

    @Override
    public Future<StartConfigRulesEvaluationResult> startConfigRulesEvaluationAsync(StartConfigRulesEvaluationRequest request, final AsyncHandler<StartConfigRulesEvaluationRequest, StartConfigRulesEvaluationResult> asyncHandler) {
        final StartConfigRulesEvaluationRequest finalRequest = (StartConfigRulesEvaluationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartConfigRulesEvaluationResult>(){

            @Override
            public StartConfigRulesEvaluationResult call() throws Exception {
                StartConfigRulesEvaluationResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeStartConfigRulesEvaluation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartConfigurationRecorderResult> startConfigurationRecorderAsync(StartConfigurationRecorderRequest request) {
        return this.startConfigurationRecorderAsync(request, null);
    }

    @Override
    public Future<StartConfigurationRecorderResult> startConfigurationRecorderAsync(StartConfigurationRecorderRequest request, final AsyncHandler<StartConfigurationRecorderRequest, StartConfigurationRecorderResult> asyncHandler) {
        final StartConfigurationRecorderRequest finalRequest = (StartConfigurationRecorderRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartConfigurationRecorderResult>(){

            @Override
            public StartConfigurationRecorderResult call() throws Exception {
                StartConfigurationRecorderResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeStartConfigurationRecorder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopConfigurationRecorderResult> stopConfigurationRecorderAsync(StopConfigurationRecorderRequest request) {
        return this.stopConfigurationRecorderAsync(request, null);
    }

    @Override
    public Future<StopConfigurationRecorderResult> stopConfigurationRecorderAsync(StopConfigurationRecorderRequest request, final AsyncHandler<StopConfigurationRecorderRequest, StopConfigurationRecorderResult> asyncHandler) {
        final StopConfigurationRecorderRequest finalRequest = (StopConfigurationRecorderRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopConfigurationRecorderResult>(){

            @Override
            public StopConfigurationRecorderResult call() throws Exception {
                StopConfigurationRecorderResult result = null;
                try {
                    result = AmazonConfigAsyncClient.this.executeStopConfigurationRecorder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

