/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.config.model.DeliveryChannel;
import com.amazonaws.services.config.model.transform.ConfigSnapshotDeliveryPropertiesJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class DeliveryChannelJsonMarshaller {
    private static DeliveryChannelJsonMarshaller instance;

    public void marshall(DeliveryChannel deliveryChannel, JSONWriter jsonWriter) {
        if (deliveryChannel == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (deliveryChannel.getName() != null) {
                jsonWriter.key("name").value((Object)deliveryChannel.getName());
            }
            if (deliveryChannel.getS3BucketName() != null) {
                jsonWriter.key("s3BucketName").value((Object)deliveryChannel.getS3BucketName());
            }
            if (deliveryChannel.getS3KeyPrefix() != null) {
                jsonWriter.key("s3KeyPrefix").value((Object)deliveryChannel.getS3KeyPrefix());
            }
            if (deliveryChannel.getSnsTopicARN() != null) {
                jsonWriter.key("snsTopicARN").value((Object)deliveryChannel.getSnsTopicARN());
            }
            if (deliveryChannel.getConfigSnapshotDeliveryProperties() != null) {
                jsonWriter.key("configSnapshotDeliveryProperties");
                ConfigSnapshotDeliveryPropertiesJsonMarshaller.getInstance().marshall(deliveryChannel.getConfigSnapshotDeliveryProperties(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeliveryChannelJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeliveryChannelJsonMarshaller();
        }
        return instance;
    }
}

