/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.CurrentPerformanceRiskRatings;
import com.amazonaws.services.computeoptimizer.model.RecommendationSourceType;
import com.amazonaws.services.computeoptimizer.model.SavingsOpportunity;
import com.amazonaws.services.computeoptimizer.model.Summary;
import com.amazonaws.services.computeoptimizer.model.transform.RecommendationSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RecommendationSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Summary> summaries;
    private String recommendationResourceType;
    private String accountId;
    private SavingsOpportunity savingsOpportunity;
    private CurrentPerformanceRiskRatings currentPerformanceRiskRatings;

    public List<Summary> getSummaries() {
        return this.summaries;
    }

    public void setSummaries(Collection<Summary> summaries) {
        if (summaries == null) {
            this.summaries = null;
            return;
        }
        this.summaries = new ArrayList<Summary>(summaries);
    }

    public RecommendationSummary withSummaries(Summary ... summaries) {
        if (this.summaries == null) {
            this.setSummaries(new ArrayList<Summary>(summaries.length));
        }
        for (Summary ele : summaries) {
            this.summaries.add(ele);
        }
        return this;
    }

    public RecommendationSummary withSummaries(Collection<Summary> summaries) {
        this.setSummaries(summaries);
        return this;
    }

    public void setRecommendationResourceType(String recommendationResourceType) {
        this.recommendationResourceType = recommendationResourceType;
    }

    public String getRecommendationResourceType() {
        return this.recommendationResourceType;
    }

    public RecommendationSummary withRecommendationResourceType(String recommendationResourceType) {
        this.setRecommendationResourceType(recommendationResourceType);
        return this;
    }

    public RecommendationSummary withRecommendationResourceType(RecommendationSourceType recommendationResourceType) {
        this.recommendationResourceType = recommendationResourceType.toString();
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public RecommendationSummary withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setSavingsOpportunity(SavingsOpportunity savingsOpportunity) {
        this.savingsOpportunity = savingsOpportunity;
    }

    public SavingsOpportunity getSavingsOpportunity() {
        return this.savingsOpportunity;
    }

    public RecommendationSummary withSavingsOpportunity(SavingsOpportunity savingsOpportunity) {
        this.setSavingsOpportunity(savingsOpportunity);
        return this;
    }

    public void setCurrentPerformanceRiskRatings(CurrentPerformanceRiskRatings currentPerformanceRiskRatings) {
        this.currentPerformanceRiskRatings = currentPerformanceRiskRatings;
    }

    public CurrentPerformanceRiskRatings getCurrentPerformanceRiskRatings() {
        return this.currentPerformanceRiskRatings;
    }

    public RecommendationSummary withCurrentPerformanceRiskRatings(CurrentPerformanceRiskRatings currentPerformanceRiskRatings) {
        this.setCurrentPerformanceRiskRatings(currentPerformanceRiskRatings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSummaries() != null) {
            sb.append("Summaries: ").append(this.getSummaries()).append(",");
        }
        if (this.getRecommendationResourceType() != null) {
            sb.append("RecommendationResourceType: ").append(this.getRecommendationResourceType()).append(",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getSavingsOpportunity() != null) {
            sb.append("SavingsOpportunity: ").append(this.getSavingsOpportunity()).append(",");
        }
        if (this.getCurrentPerformanceRiskRatings() != null) {
            sb.append("CurrentPerformanceRiskRatings: ").append(this.getCurrentPerformanceRiskRatings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSummary)) {
            return false;
        }
        RecommendationSummary other = (RecommendationSummary)obj;
        if (other.getSummaries() == null ^ this.getSummaries() == null) {
            return false;
        }
        if (other.getSummaries() != null && !other.getSummaries().equals(this.getSummaries())) {
            return false;
        }
        if (other.getRecommendationResourceType() == null ^ this.getRecommendationResourceType() == null) {
            return false;
        }
        if (other.getRecommendationResourceType() != null && !other.getRecommendationResourceType().equals(this.getRecommendationResourceType())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getSavingsOpportunity() == null ^ this.getSavingsOpportunity() == null) {
            return false;
        }
        if (other.getSavingsOpportunity() != null && !other.getSavingsOpportunity().equals(this.getSavingsOpportunity())) {
            return false;
        }
        if (other.getCurrentPerformanceRiskRatings() == null ^ this.getCurrentPerformanceRiskRatings() == null) {
            return false;
        }
        return other.getCurrentPerformanceRiskRatings() == null || other.getCurrentPerformanceRiskRatings().equals(this.getCurrentPerformanceRiskRatings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSummaries() == null ? 0 : this.getSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationResourceType() == null ? 0 : this.getRecommendationResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getSavingsOpportunity() == null ? 0 : this.getSavingsOpportunity().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentPerformanceRiskRatings() == null ? 0 : this.getCurrentPerformanceRiskRatings().hashCode());
        return hashCode;
    }

    public RecommendationSummary clone() {
        try {
            return (RecommendationSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecommendationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

