/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SubscribeToDatasetRequestMarshaller
implements Marshaller<Request<SubscribeToDatasetRequest>, SubscribeToDatasetRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";

    public Request<SubscribeToDatasetRequest> marshall(SubscribeToDatasetRequest subscribeToDatasetRequest) {
        if (subscribeToDatasetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)subscribeToDatasetRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", subscribeToDatasetRequest.getIdentityPoolId() != null ? StringUtils.fromString((String)subscribeToDatasetRequest.getIdentityPoolId()) : "");
        uriResourcePath = uriResourcePath.replace("{IdentityId}", subscribeToDatasetRequest.getIdentityId() != null ? StringUtils.fromString((String)subscribeToDatasetRequest.getIdentityId()) : "");
        uriResourcePath = uriResourcePath.replace("{DatasetName}", subscribeToDatasetRequest.getDatasetName() != null ? StringUtils.fromString((String)subscribeToDatasetRequest.getDatasetName()) : "");
        uriResourcePath = uriResourcePath.replace("{DeviceId}", subscribeToDatasetRequest.getDeviceId() != null ? StringUtils.fromString((String)subscribeToDatasetRequest.getDeviceId()) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

