/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codepipeline.model.PipelineDeclaration;
import com.amazonaws.services.codepipeline.model.StageDeclaration;
import com.amazonaws.services.codepipeline.model.transform.ArtifactStoreJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.StageDeclarationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class PipelineDeclarationJsonMarshaller {
    private static PipelineDeclarationJsonMarshaller instance;

    public void marshall(PipelineDeclaration pipelineDeclaration, JSONWriter jsonWriter) {
        if (pipelineDeclaration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<StageDeclaration> stagesList;
            jsonWriter.object();
            if (pipelineDeclaration.getName() != null) {
                jsonWriter.key("name").value((Object)pipelineDeclaration.getName());
            }
            if (pipelineDeclaration.getRoleArn() != null) {
                jsonWriter.key("roleArn").value((Object)pipelineDeclaration.getRoleArn());
            }
            if (pipelineDeclaration.getArtifactStore() != null) {
                jsonWriter.key("artifactStore");
                ArtifactStoreJsonMarshaller.getInstance().marshall(pipelineDeclaration.getArtifactStore(), jsonWriter);
            }
            if ((stagesList = pipelineDeclaration.getStages()) != null) {
                jsonWriter.key("stages");
                jsonWriter.array();
                for (StageDeclaration stagesListValue : stagesList) {
                    if (stagesListValue == null) continue;
                    StageDeclarationJsonMarshaller.getInstance().marshall(stagesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (pipelineDeclaration.getVersion() != null) {
                jsonWriter.key("version").value((Object)pipelineDeclaration.getVersion());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PipelineDeclarationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PipelineDeclarationJsonMarshaller();
        }
        return instance;
    }
}

