/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codepipeline.AWSCodePipelineAsync;
import com.amazonaws.services.codepipeline.AWSCodePipelineClient;
import com.amazonaws.services.codepipeline.model.AcknowledgeJobRequest;
import com.amazonaws.services.codepipeline.model.AcknowledgeJobResult;
import com.amazonaws.services.codepipeline.model.AcknowledgeThirdPartyJobRequest;
import com.amazonaws.services.codepipeline.model.AcknowledgeThirdPartyJobResult;
import com.amazonaws.services.codepipeline.model.CreateCustomActionTypeRequest;
import com.amazonaws.services.codepipeline.model.CreateCustomActionTypeResult;
import com.amazonaws.services.codepipeline.model.CreatePipelineRequest;
import com.amazonaws.services.codepipeline.model.CreatePipelineResult;
import com.amazonaws.services.codepipeline.model.DeleteCustomActionTypeRequest;
import com.amazonaws.services.codepipeline.model.DeletePipelineRequest;
import com.amazonaws.services.codepipeline.model.DisableStageTransitionRequest;
import com.amazonaws.services.codepipeline.model.EnableStageTransitionRequest;
import com.amazonaws.services.codepipeline.model.GetJobDetailsRequest;
import com.amazonaws.services.codepipeline.model.GetJobDetailsResult;
import com.amazonaws.services.codepipeline.model.GetPipelineRequest;
import com.amazonaws.services.codepipeline.model.GetPipelineResult;
import com.amazonaws.services.codepipeline.model.GetPipelineStateRequest;
import com.amazonaws.services.codepipeline.model.GetPipelineStateResult;
import com.amazonaws.services.codepipeline.model.GetThirdPartyJobDetailsRequest;
import com.amazonaws.services.codepipeline.model.GetThirdPartyJobDetailsResult;
import com.amazonaws.services.codepipeline.model.ListActionTypesRequest;
import com.amazonaws.services.codepipeline.model.ListActionTypesResult;
import com.amazonaws.services.codepipeline.model.ListPipelinesRequest;
import com.amazonaws.services.codepipeline.model.ListPipelinesResult;
import com.amazonaws.services.codepipeline.model.PollForJobsRequest;
import com.amazonaws.services.codepipeline.model.PollForJobsResult;
import com.amazonaws.services.codepipeline.model.PollForThirdPartyJobsRequest;
import com.amazonaws.services.codepipeline.model.PollForThirdPartyJobsResult;
import com.amazonaws.services.codepipeline.model.PutActionRevisionRequest;
import com.amazonaws.services.codepipeline.model.PutActionRevisionResult;
import com.amazonaws.services.codepipeline.model.PutJobFailureResultRequest;
import com.amazonaws.services.codepipeline.model.PutJobSuccessResultRequest;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobFailureResultRequest;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest;
import com.amazonaws.services.codepipeline.model.StartPipelineExecutionRequest;
import com.amazonaws.services.codepipeline.model.StartPipelineExecutionResult;
import com.amazonaws.services.codepipeline.model.UpdatePipelineRequest;
import com.amazonaws.services.codepipeline.model.UpdatePipelineResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSCodePipelineAsyncClient
extends AWSCodePipelineClient
implements AWSCodePipelineAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSCodePipelineAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSCodePipelineAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCodePipelineAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSCodePipelineAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AWSCodePipelineAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcknowledgeJobResult> acknowledgeJobAsync(AcknowledgeJobRequest request) {
        return this.acknowledgeJobAsync(request, null);
    }

    @Override
    public Future<AcknowledgeJobResult> acknowledgeJobAsync(final AcknowledgeJobRequest request, final AsyncHandler<AcknowledgeJobRequest, AcknowledgeJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<AcknowledgeJobResult>(){

            @Override
            public AcknowledgeJobResult call() throws Exception {
                AcknowledgeJobResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.acknowledgeJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AcknowledgeThirdPartyJobResult> acknowledgeThirdPartyJobAsync(AcknowledgeThirdPartyJobRequest request) {
        return this.acknowledgeThirdPartyJobAsync(request, null);
    }

    @Override
    public Future<AcknowledgeThirdPartyJobResult> acknowledgeThirdPartyJobAsync(final AcknowledgeThirdPartyJobRequest request, final AsyncHandler<AcknowledgeThirdPartyJobRequest, AcknowledgeThirdPartyJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<AcknowledgeThirdPartyJobResult>(){

            @Override
            public AcknowledgeThirdPartyJobResult call() throws Exception {
                AcknowledgeThirdPartyJobResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.acknowledgeThirdPartyJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCustomActionTypeResult> createCustomActionTypeAsync(CreateCustomActionTypeRequest request) {
        return this.createCustomActionTypeAsync(request, null);
    }

    @Override
    public Future<CreateCustomActionTypeResult> createCustomActionTypeAsync(final CreateCustomActionTypeRequest request, final AsyncHandler<CreateCustomActionTypeRequest, CreateCustomActionTypeResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateCustomActionTypeResult>(){

            @Override
            public CreateCustomActionTypeResult call() throws Exception {
                CreateCustomActionTypeResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.createCustomActionType(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(CreatePipelineRequest request) {
        return this.createPipelineAsync(request, null);
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(final CreatePipelineRequest request, final AsyncHandler<CreatePipelineRequest, CreatePipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() throws Exception {
                CreatePipelineResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.createPipeline(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteCustomActionTypeAsync(DeleteCustomActionTypeRequest request) {
        return this.deleteCustomActionTypeAsync(request, null);
    }

    @Override
    public Future<Void> deleteCustomActionTypeAsync(final DeleteCustomActionTypeRequest request, final AsyncHandler<DeleteCustomActionTypeRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.deleteCustomActionType(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deletePipelineAsync(DeletePipelineRequest request) {
        return this.deletePipelineAsync(request, null);
    }

    @Override
    public Future<Void> deletePipelineAsync(final DeletePipelineRequest request, final AsyncHandler<DeletePipelineRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.deletePipeline(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> disableStageTransitionAsync(DisableStageTransitionRequest request) {
        return this.disableStageTransitionAsync(request, null);
    }

    @Override
    public Future<Void> disableStageTransitionAsync(final DisableStageTransitionRequest request, final AsyncHandler<DisableStageTransitionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.disableStageTransition(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> enableStageTransitionAsync(EnableStageTransitionRequest request) {
        return this.enableStageTransitionAsync(request, null);
    }

    @Override
    public Future<Void> enableStageTransitionAsync(final EnableStageTransitionRequest request, final AsyncHandler<EnableStageTransitionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.enableStageTransition(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetJobDetailsResult> getJobDetailsAsync(GetJobDetailsRequest request) {
        return this.getJobDetailsAsync(request, null);
    }

    @Override
    public Future<GetJobDetailsResult> getJobDetailsAsync(final GetJobDetailsRequest request, final AsyncHandler<GetJobDetailsRequest, GetJobDetailsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetJobDetailsResult>(){

            @Override
            public GetJobDetailsResult call() throws Exception {
                GetJobDetailsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getJobDetails(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineResult> getPipelineAsync(GetPipelineRequest request) {
        return this.getPipelineAsync(request, null);
    }

    @Override
    public Future<GetPipelineResult> getPipelineAsync(final GetPipelineRequest request, final AsyncHandler<GetPipelineRequest, GetPipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetPipelineResult>(){

            @Override
            public GetPipelineResult call() throws Exception {
                GetPipelineResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getPipeline(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineStateResult> getPipelineStateAsync(GetPipelineStateRequest request) {
        return this.getPipelineStateAsync(request, null);
    }

    @Override
    public Future<GetPipelineStateResult> getPipelineStateAsync(final GetPipelineStateRequest request, final AsyncHandler<GetPipelineStateRequest, GetPipelineStateResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetPipelineStateResult>(){

            @Override
            public GetPipelineStateResult call() throws Exception {
                GetPipelineStateResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getPipelineState(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetThirdPartyJobDetailsResult> getThirdPartyJobDetailsAsync(GetThirdPartyJobDetailsRequest request) {
        return this.getThirdPartyJobDetailsAsync(request, null);
    }

    @Override
    public Future<GetThirdPartyJobDetailsResult> getThirdPartyJobDetailsAsync(final GetThirdPartyJobDetailsRequest request, final AsyncHandler<GetThirdPartyJobDetailsRequest, GetThirdPartyJobDetailsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetThirdPartyJobDetailsResult>(){

            @Override
            public GetThirdPartyJobDetailsResult call() throws Exception {
                GetThirdPartyJobDetailsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getThirdPartyJobDetails(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListActionTypesResult> listActionTypesAsync(ListActionTypesRequest request) {
        return this.listActionTypesAsync(request, null);
    }

    @Override
    public Future<ListActionTypesResult> listActionTypesAsync(final ListActionTypesRequest request, final AsyncHandler<ListActionTypesRequest, ListActionTypesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListActionTypesResult>(){

            @Override
            public ListActionTypesResult call() throws Exception {
                ListActionTypesResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.listActionTypes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(ListPipelinesRequest request) {
        return this.listPipelinesAsync(request, null);
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(final ListPipelinesRequest request, final AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() throws Exception {
                ListPipelinesResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.listPipelines(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PollForJobsResult> pollForJobsAsync(PollForJobsRequest request) {
        return this.pollForJobsAsync(request, null);
    }

    @Override
    public Future<PollForJobsResult> pollForJobsAsync(final PollForJobsRequest request, final AsyncHandler<PollForJobsRequest, PollForJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PollForJobsResult>(){

            @Override
            public PollForJobsResult call() throws Exception {
                PollForJobsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.pollForJobs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PollForThirdPartyJobsResult> pollForThirdPartyJobsAsync(PollForThirdPartyJobsRequest request) {
        return this.pollForThirdPartyJobsAsync(request, null);
    }

    @Override
    public Future<PollForThirdPartyJobsResult> pollForThirdPartyJobsAsync(final PollForThirdPartyJobsRequest request, final AsyncHandler<PollForThirdPartyJobsRequest, PollForThirdPartyJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PollForThirdPartyJobsResult>(){

            @Override
            public PollForThirdPartyJobsResult call() throws Exception {
                PollForThirdPartyJobsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.pollForThirdPartyJobs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutActionRevisionResult> putActionRevisionAsync(PutActionRevisionRequest request) {
        return this.putActionRevisionAsync(request, null);
    }

    @Override
    public Future<PutActionRevisionResult> putActionRevisionAsync(final PutActionRevisionRequest request, final AsyncHandler<PutActionRevisionRequest, PutActionRevisionResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutActionRevisionResult>(){

            @Override
            public PutActionRevisionResult call() throws Exception {
                PutActionRevisionResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.putActionRevision(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> putJobFailureResultAsync(PutJobFailureResultRequest request) {
        return this.putJobFailureResultAsync(request, null);
    }

    @Override
    public Future<Void> putJobFailureResultAsync(final PutJobFailureResultRequest request, final AsyncHandler<PutJobFailureResultRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.putJobFailureResult(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> putJobSuccessResultAsync(PutJobSuccessResultRequest request) {
        return this.putJobSuccessResultAsync(request, null);
    }

    @Override
    public Future<Void> putJobSuccessResultAsync(final PutJobSuccessResultRequest request, final AsyncHandler<PutJobSuccessResultRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.putJobSuccessResult(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> putThirdPartyJobFailureResultAsync(PutThirdPartyJobFailureResultRequest request) {
        return this.putThirdPartyJobFailureResultAsync(request, null);
    }

    @Override
    public Future<Void> putThirdPartyJobFailureResultAsync(final PutThirdPartyJobFailureResultRequest request, final AsyncHandler<PutThirdPartyJobFailureResultRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.putThirdPartyJobFailureResult(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> putThirdPartyJobSuccessResultAsync(PutThirdPartyJobSuccessResultRequest request) {
        return this.putThirdPartyJobSuccessResultAsync(request, null);
    }

    @Override
    public Future<Void> putThirdPartyJobSuccessResultAsync(final PutThirdPartyJobSuccessResultRequest request, final AsyncHandler<PutThirdPartyJobSuccessResultRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCodePipelineAsyncClient.this.putThirdPartyJobSuccessResult(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartPipelineExecutionResult> startPipelineExecutionAsync(StartPipelineExecutionRequest request) {
        return this.startPipelineExecutionAsync(request, null);
    }

    @Override
    public Future<StartPipelineExecutionResult> startPipelineExecutionAsync(final StartPipelineExecutionRequest request, final AsyncHandler<StartPipelineExecutionRequest, StartPipelineExecutionResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartPipelineExecutionResult>(){

            @Override
            public StartPipelineExecutionResult call() throws Exception {
                StartPipelineExecutionResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.startPipelineExecution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(UpdatePipelineRequest request) {
        return this.updatePipelineAsync(request, null);
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(final UpdatePipelineRequest request, final AsyncHandler<UpdatePipelineRequest, UpdatePipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdatePipelineResult>(){

            @Override
            public UpdatePipelineResult call() throws Exception {
                UpdatePipelineResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.updatePipeline(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

