/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeguruprofiler.model.Anomaly;
import java.util.List;

@SdkInternalApi
public class AnomalyMarshaller {
    private static final MarshallingInfo<List> INSTANCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instances").build();
    private static final MarshallingInfo<StructuredPojo> METRIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metric").build();
    private static final MarshallingInfo<String> REASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reason").build();
    private static final AnomalyMarshaller instance = new AnomalyMarshaller();

    public static AnomalyMarshaller getInstance() {
        return instance;
    }

    public void marshall(Anomaly anomaly, ProtocolMarshaller protocolMarshaller) {
        if (anomaly == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(anomaly.getInstances(), INSTANCES_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getMetric(), METRIC_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getReason(), REASON_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

