/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.InstanceSummary;
import com.amazonaws.services.codedeploy.model.LifecycleEvent;
import com.amazonaws.services.codedeploy.model.transform.LifecycleEventJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class InstanceSummaryJsonMarshaller {
    private static InstanceSummaryJsonMarshaller instance;

    public void marshall(InstanceSummary instanceSummary, JSONWriter jsonWriter) {
        if (instanceSummary == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList lifecycleEventsList;
            jsonWriter.object();
            if (instanceSummary.getDeploymentId() != null) {
                jsonWriter.key("deploymentId").value((Object)instanceSummary.getDeploymentId());
            }
            if (instanceSummary.getInstanceId() != null) {
                jsonWriter.key("instanceId").value((Object)instanceSummary.getInstanceId());
            }
            if (instanceSummary.getStatus() != null) {
                jsonWriter.key("status").value((Object)instanceSummary.getStatus());
            }
            if (instanceSummary.getLastUpdatedAt() != null) {
                jsonWriter.key("lastUpdatedAt").value(instanceSummary.getLastUpdatedAt());
            }
            if (!(lifecycleEventsList = (SdkInternalList)instanceSummary.getLifecycleEvents()).isEmpty() || !lifecycleEventsList.isAutoConstruct()) {
                jsonWriter.key("lifecycleEvents");
                jsonWriter.array();
                for (LifecycleEvent lifecycleEventsListValue : lifecycleEventsList) {
                    if (lifecycleEventsListValue == null) continue;
                    LifecycleEventJsonMarshaller.getInstance().marshall(lifecycleEventsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceSummaryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceSummaryJsonMarshaller();
        }
        return instance;
    }
}

