/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codecommit.model.BatchGetRepositoriesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class BatchGetRepositoriesRequestMarshaller
implements Marshaller<Request<BatchGetRepositoriesRequest>, BatchGetRepositoriesRequest> {
    public Request<BatchGetRepositoriesRequest> marshall(BatchGetRepositoriesRequest batchGetRepositoriesRequest) {
        if (batchGetRepositoriesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchGetRepositoriesRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.BatchGetRepositories");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            List<String> repositoryNamesList = batchGetRepositoriesRequest.getRepositoryNames();
            if (repositoryNamesList != null) {
                jsonGenerator.writeFieldName("repositoryNames");
                jsonGenerator.writeStartArray();
                for (String repositoryNamesListValue : repositoryNamesList) {
                    if (repositoryNamesListValue == null) continue;
                    jsonGenerator.writeValue(repositoryNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

