/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeartifact.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.codeartifact.model.DomainSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDomainsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DomainSummary> domains;
    private String nextToken;

    public List<DomainSummary> getDomains() {
        return this.domains;
    }

    public void setDomains(Collection<DomainSummary> domains) {
        if (domains == null) {
            this.domains = null;
            return;
        }
        this.domains = new ArrayList<DomainSummary>(domains);
    }

    public ListDomainsResult withDomains(DomainSummary ... domains) {
        if (this.domains == null) {
            this.setDomains(new ArrayList<DomainSummary>(domains.length));
        }
        for (DomainSummary ele : domains) {
            this.domains.add(ele);
        }
        return this;
    }

    public ListDomainsResult withDomains(Collection<DomainSummary> domains) {
        this.setDomains(domains);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDomainsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomains() != null) {
            sb.append("Domains: ").append(this.getDomains()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsResult)) {
            return false;
        }
        ListDomainsResult other = (ListDomainsResult)obj;
        if (other.getDomains() == null ^ this.getDomains() == null) {
            return false;
        }
        if (other.getDomains() != null && !other.getDomains().equals(this.getDomains())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomains() == null ? 0 : this.getDomains().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListDomainsResult clone() {
        try {
            return (ListDomainsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

