/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeartifact.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codeartifact.model.Tag;
import com.amazonaws.services.codeartifact.model.UpstreamRepository;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateRepositoryRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domain;
    private String domainOwner;
    private String repository;
    private String description;
    private List<UpstreamRepository> upstreams;
    private List<Tag> tags;

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public CreateRepositoryRequest withDomain(String domain) {
        this.setDomain(domain);
        return this;
    }

    public void setDomainOwner(String domainOwner) {
        this.domainOwner = domainOwner;
    }

    public String getDomainOwner() {
        return this.domainOwner;
    }

    public CreateRepositoryRequest withDomainOwner(String domainOwner) {
        this.setDomainOwner(domainOwner);
        return this;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getRepository() {
        return this.repository;
    }

    public CreateRepositoryRequest withRepository(String repository) {
        this.setRepository(repository);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateRepositoryRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<UpstreamRepository> getUpstreams() {
        return this.upstreams;
    }

    public void setUpstreams(Collection<UpstreamRepository> upstreams) {
        if (upstreams == null) {
            this.upstreams = null;
            return;
        }
        this.upstreams = new ArrayList<UpstreamRepository>(upstreams);
    }

    public CreateRepositoryRequest withUpstreams(UpstreamRepository ... upstreams) {
        if (this.upstreams == null) {
            this.setUpstreams(new ArrayList<UpstreamRepository>(upstreams.length));
        }
        for (UpstreamRepository ele : upstreams) {
            this.upstreams.add(ele);
        }
        return this;
    }

    public CreateRepositoryRequest withUpstreams(Collection<UpstreamRepository> upstreams) {
        this.setUpstreams(upstreams);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateRepositoryRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateRepositoryRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomain() != null) {
            sb.append("Domain: ").append(this.getDomain()).append(",");
        }
        if (this.getDomainOwner() != null) {
            sb.append("DomainOwner: ").append(this.getDomainOwner()).append(",");
        }
        if (this.getRepository() != null) {
            sb.append("Repository: ").append(this.getRepository()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getUpstreams() != null) {
            sb.append("Upstreams: ").append(this.getUpstreams()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRepositoryRequest)) {
            return false;
        }
        CreateRepositoryRequest other = (CreateRepositoryRequest)obj;
        if (other.getDomain() == null ^ this.getDomain() == null) {
            return false;
        }
        if (other.getDomain() != null && !other.getDomain().equals(this.getDomain())) {
            return false;
        }
        if (other.getDomainOwner() == null ^ this.getDomainOwner() == null) {
            return false;
        }
        if (other.getDomainOwner() != null && !other.getDomainOwner().equals(this.getDomainOwner())) {
            return false;
        }
        if (other.getRepository() == null ^ this.getRepository() == null) {
            return false;
        }
        if (other.getRepository() != null && !other.getRepository().equals(this.getRepository())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getUpstreams() == null ^ this.getUpstreams() == null) {
            return false;
        }
        if (other.getUpstreams() != null && !other.getUpstreams().equals(this.getUpstreams())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomain() == null ? 0 : this.getDomain().hashCode());
        hashCode = 31 * hashCode + (this.getDomainOwner() == null ? 0 : this.getDomainOwner().hashCode());
        hashCode = 31 * hashCode + (this.getRepository() == null ? 0 : this.getRepository().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getUpstreams() == null ? 0 : this.getUpstreams().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateRepositoryRequest clone() {
        return (CreateRepositoryRequest)super.clone();
    }
}

