/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch;

import com.amazonaws.services.cloudwatch.model.Dimension;
import java.util.Comparator;

enum DimensionComparator implements Comparator<Dimension>
{
    INSTANCE;

    private static final int NON_NULLS = 2;

    @Override
    public int compare(Dimension dim1, Dimension dim2) {
        int result = this.nullCompare(dim1, dim2);
        if (result == 2 && (result = this.nullSafeCompare(dim1.getName(), dim2.getName())) == 0) {
            return this.nullSafeCompare(dim1.getValue(), dim2.getValue());
        }
        return result;
    }

    private int nullSafeCompare(String first, String second) {
        int result = this.nullCompare(first, second);
        return result == 2 ? first.compareTo(second) : result;
    }

    private int nullCompare(Object first, Object second) {
        if (first == second) {
            return 0;
        }
        if (first == null) {
            return -1;
        }
        if (second == null) {
            return 1;
        }
        return 2;
    }
}

