/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatchevidently.model.LaunchExecution;
import com.amazonaws.services.cloudwatchevidently.model.LaunchGroup;
import com.amazonaws.services.cloudwatchevidently.model.LaunchStatus;
import com.amazonaws.services.cloudwatchevidently.model.LaunchType;
import com.amazonaws.services.cloudwatchevidently.model.MetricMonitor;
import com.amazonaws.services.cloudwatchevidently.model.ScheduledSplitsLaunchDefinition;
import com.amazonaws.services.cloudwatchevidently.model.transform.LaunchMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Launch
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private Date createdTime;
    private String description;
    private LaunchExecution execution;
    private List<LaunchGroup> groups;
    private Date lastUpdatedTime;
    private List<MetricMonitor> metricMonitors;
    private String name;
    private String project;
    private String randomizationSalt;
    private ScheduledSplitsLaunchDefinition scheduledSplitsDefinition;
    private String status;
    private String statusReason;
    private Map<String, String> tags;
    private String type;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Launch withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Launch withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Launch withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setExecution(LaunchExecution execution) {
        this.execution = execution;
    }

    public LaunchExecution getExecution() {
        return this.execution;
    }

    public Launch withExecution(LaunchExecution execution) {
        this.setExecution(execution);
        return this;
    }

    public List<LaunchGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<LaunchGroup> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new ArrayList<LaunchGroup>(groups);
    }

    public Launch withGroups(LaunchGroup ... groups) {
        if (this.groups == null) {
            this.setGroups(new ArrayList<LaunchGroup>(groups.length));
        }
        for (LaunchGroup ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    public Launch withGroups(Collection<LaunchGroup> groups) {
        this.setGroups(groups);
        return this;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Launch withLastUpdatedTime(Date lastUpdatedTime) {
        this.setLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    public List<MetricMonitor> getMetricMonitors() {
        return this.metricMonitors;
    }

    public void setMetricMonitors(Collection<MetricMonitor> metricMonitors) {
        if (metricMonitors == null) {
            this.metricMonitors = null;
            return;
        }
        this.metricMonitors = new ArrayList<MetricMonitor>(metricMonitors);
    }

    public Launch withMetricMonitors(MetricMonitor ... metricMonitors) {
        if (this.metricMonitors == null) {
            this.setMetricMonitors(new ArrayList<MetricMonitor>(metricMonitors.length));
        }
        for (MetricMonitor ele : metricMonitors) {
            this.metricMonitors.add(ele);
        }
        return this;
    }

    public Launch withMetricMonitors(Collection<MetricMonitor> metricMonitors) {
        this.setMetricMonitors(metricMonitors);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Launch withName(String name) {
        this.setName(name);
        return this;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public Launch withProject(String project) {
        this.setProject(project);
        return this;
    }

    public void setRandomizationSalt(String randomizationSalt) {
        this.randomizationSalt = randomizationSalt;
    }

    public String getRandomizationSalt() {
        return this.randomizationSalt;
    }

    public Launch withRandomizationSalt(String randomizationSalt) {
        this.setRandomizationSalt(randomizationSalt);
        return this;
    }

    public void setScheduledSplitsDefinition(ScheduledSplitsLaunchDefinition scheduledSplitsDefinition) {
        this.scheduledSplitsDefinition = scheduledSplitsDefinition;
    }

    public ScheduledSplitsLaunchDefinition getScheduledSplitsDefinition() {
        return this.scheduledSplitsDefinition;
    }

    public Launch withScheduledSplitsDefinition(ScheduledSplitsLaunchDefinition scheduledSplitsDefinition) {
        this.setScheduledSplitsDefinition(scheduledSplitsDefinition);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Launch withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Launch withStatus(LaunchStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public Launch withStatusReason(String statusReason) {
        this.setStatusReason(statusReason);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Launch withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Launch addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Launch clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Launch withType(String type) {
        this.setType(type);
        return this;
    }

    public Launch withType(LaunchType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getExecution() != null) {
            sb.append("Execution: ").append(this.getExecution()).append(",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups()).append(",");
        }
        if (this.getLastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.getLastUpdatedTime()).append(",");
        }
        if (this.getMetricMonitors() != null) {
            sb.append("MetricMonitors: ").append(this.getMetricMonitors()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getProject() != null) {
            sb.append("Project: ").append(this.getProject()).append(",");
        }
        if (this.getRandomizationSalt() != null) {
            sb.append("RandomizationSalt: ").append(this.getRandomizationSalt()).append(",");
        }
        if (this.getScheduledSplitsDefinition() != null) {
            sb.append("ScheduledSplitsDefinition: ").append(this.getScheduledSplitsDefinition()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusReason() != null) {
            sb.append("StatusReason: ").append(this.getStatusReason()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Launch)) {
            return false;
        }
        Launch other = (Launch)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getExecution() == null ^ this.getExecution() == null) {
            return false;
        }
        if (other.getExecution() != null && !other.getExecution().equals(this.getExecution())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null) {
            return false;
        }
        if (other.getLastUpdatedTime() != null && !other.getLastUpdatedTime().equals(this.getLastUpdatedTime())) {
            return false;
        }
        if (other.getMetricMonitors() == null ^ this.getMetricMonitors() == null) {
            return false;
        }
        if (other.getMetricMonitors() != null && !other.getMetricMonitors().equals(this.getMetricMonitors())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getProject() == null ^ this.getProject() == null) {
            return false;
        }
        if (other.getProject() != null && !other.getProject().equals(this.getProject())) {
            return false;
        }
        if (other.getRandomizationSalt() == null ^ this.getRandomizationSalt() == null) {
            return false;
        }
        if (other.getRandomizationSalt() != null && !other.getRandomizationSalt().equals(this.getRandomizationSalt())) {
            return false;
        }
        if (other.getScheduledSplitsDefinition() == null ^ this.getScheduledSplitsDefinition() == null) {
            return false;
        }
        if (other.getScheduledSplitsDefinition() != null && !other.getScheduledSplitsDefinition().equals(this.getScheduledSplitsDefinition())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusReason() == null ^ this.getStatusReason() == null) {
            return false;
        }
        if (other.getStatusReason() != null && !other.getStatusReason().equals(this.getStatusReason())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getExecution() == null ? 0 : this.getExecution().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTime() == null ? 0 : this.getLastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getMetricMonitors() == null ? 0 : this.getMetricMonitors().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getProject() == null ? 0 : this.getProject().hashCode());
        hashCode = 31 * hashCode + (this.getRandomizationSalt() == null ? 0 : this.getRandomizationSalt().hashCode());
        hashCode = 31 * hashCode + (this.getScheduledSplitsDefinition() == null ? 0 : this.getScheduledSplitsDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusReason() == null ? 0 : this.getStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public Launch clone() {
        try {
            return (Launch)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LaunchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

