/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.DescribeAnomalyDetectorsRequest;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeAnomalyDetectorsRequestMarshaller
implements Marshaller<Request<DescribeAnomalyDetectorsRequest>, DescribeAnomalyDetectorsRequest> {
    public Request<DescribeAnomalyDetectorsRequest> marshall(DescribeAnomalyDetectorsRequest describeAnomalyDetectorsRequest) {
        if (describeAnomalyDetectorsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAnomalyDetectorsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DescribeAnomalyDetectors");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAnomalyDetectorsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeAnomalyDetectorsRequest.getNextToken()));
        }
        if (describeAnomalyDetectorsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeAnomalyDetectorsRequest.getMaxResults()));
        }
        if (describeAnomalyDetectorsRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)describeAnomalyDetectorsRequest.getNamespace()));
        }
        if (describeAnomalyDetectorsRequest.getMetricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString((String)describeAnomalyDetectorsRequest.getMetricName()));
        }
        if (!describeAnomalyDetectorsRequest.getDimensions().isEmpty() || !((SdkInternalList)describeAnomalyDetectorsRequest.getDimensions()).isAutoConstruct()) {
            SdkInternalList dimensionsList = (SdkInternalList)describeAnomalyDetectorsRequest.getDimensions();
            int dimensionsListIndex = 1;
            for (Dimension dimensionsListValue : dimensionsList) {
                if (dimensionsListValue != null) {
                    if (dimensionsListValue.getName() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                    }
                    if (dimensionsListValue.getValue() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                    }
                }
                ++dimensionsListIndex;
            }
        }
        return request;
    }
}

