/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsync;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsyncClientBuilder;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DeleteAlarmsResult;
import com.amazonaws.services.cloudwatch.model.DeleteAnomalyDetectorRequest;
import com.amazonaws.services.cloudwatch.model.DeleteAnomalyDetectorResult;
import com.amazonaws.services.cloudwatch.model.DeleteDashboardsRequest;
import com.amazonaws.services.cloudwatch.model.DeleteDashboardsResult;
import com.amazonaws.services.cloudwatch.model.DeleteInsightRulesRequest;
import com.amazonaws.services.cloudwatch.model.DeleteInsightRulesResult;
import com.amazonaws.services.cloudwatch.model.DeleteMetricStreamRequest;
import com.amazonaws.services.cloudwatch.model.DeleteMetricStreamResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsResult;
import com.amazonaws.services.cloudwatch.model.DescribeAnomalyDetectorsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAnomalyDetectorsResult;
import com.amazonaws.services.cloudwatch.model.DescribeInsightRulesRequest;
import com.amazonaws.services.cloudwatch.model.DescribeInsightRulesResult;
import com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest;
import com.amazonaws.services.cloudwatch.model.DisableAlarmActionsResult;
import com.amazonaws.services.cloudwatch.model.DisableInsightRulesRequest;
import com.amazonaws.services.cloudwatch.model.DisableInsightRulesResult;
import com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest;
import com.amazonaws.services.cloudwatch.model.EnableAlarmActionsResult;
import com.amazonaws.services.cloudwatch.model.EnableInsightRulesRequest;
import com.amazonaws.services.cloudwatch.model.EnableInsightRulesResult;
import com.amazonaws.services.cloudwatch.model.GetDashboardRequest;
import com.amazonaws.services.cloudwatch.model.GetDashboardResult;
import com.amazonaws.services.cloudwatch.model.GetInsightRuleReportRequest;
import com.amazonaws.services.cloudwatch.model.GetInsightRuleReportResult;
import com.amazonaws.services.cloudwatch.model.GetMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricDataResult;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import com.amazonaws.services.cloudwatch.model.GetMetricStreamRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStreamResult;
import com.amazonaws.services.cloudwatch.model.GetMetricWidgetImageRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricWidgetImageResult;
import com.amazonaws.services.cloudwatch.model.ListDashboardsRequest;
import com.amazonaws.services.cloudwatch.model.ListDashboardsResult;
import com.amazonaws.services.cloudwatch.model.ListMetricStreamsRequest;
import com.amazonaws.services.cloudwatch.model.ListMetricStreamsResult;
import com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.amazonaws.services.cloudwatch.model.ListMetricsResult;
import com.amazonaws.services.cloudwatch.model.ListTagsForResourceRequest;
import com.amazonaws.services.cloudwatch.model.ListTagsForResourceResult;
import com.amazonaws.services.cloudwatch.model.PutAnomalyDetectorRequest;
import com.amazonaws.services.cloudwatch.model.PutAnomalyDetectorResult;
import com.amazonaws.services.cloudwatch.model.PutCompositeAlarmRequest;
import com.amazonaws.services.cloudwatch.model.PutCompositeAlarmResult;
import com.amazonaws.services.cloudwatch.model.PutDashboardRequest;
import com.amazonaws.services.cloudwatch.model.PutDashboardResult;
import com.amazonaws.services.cloudwatch.model.PutInsightRuleRequest;
import com.amazonaws.services.cloudwatch.model.PutInsightRuleResult;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmResult;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricDataResult;
import com.amazonaws.services.cloudwatch.model.PutMetricStreamRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricStreamResult;
import com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest;
import com.amazonaws.services.cloudwatch.model.SetAlarmStateResult;
import com.amazonaws.services.cloudwatch.model.StartMetricStreamsRequest;
import com.amazonaws.services.cloudwatch.model.StartMetricStreamsResult;
import com.amazonaws.services.cloudwatch.model.StopMetricStreamsRequest;
import com.amazonaws.services.cloudwatch.model.StopMetricStreamsResult;
import com.amazonaws.services.cloudwatch.model.TagResourceRequest;
import com.amazonaws.services.cloudwatch.model.TagResourceResult;
import com.amazonaws.services.cloudwatch.model.UntagResourceRequest;
import com.amazonaws.services.cloudwatch.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCloudWatchAsyncClient
extends AmazonCloudWatchClient
implements AmazonCloudWatchAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonCloudWatchAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonCloudWatchAsyncClientBuilder asyncBuilder() {
        return AmazonCloudWatchAsyncClientBuilder.standard();
    }

    AmazonCloudWatchAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonCloudWatchAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteAlarmsResult> deleteAlarmsAsync(DeleteAlarmsRequest request) {
        return this.deleteAlarmsAsync(request, null);
    }

    @Override
    public Future<DeleteAlarmsResult> deleteAlarmsAsync(DeleteAlarmsRequest request, final AsyncHandler<DeleteAlarmsRequest, DeleteAlarmsResult> asyncHandler) {
        final DeleteAlarmsRequest finalRequest = (DeleteAlarmsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAlarmsResult>(){

            @Override
            public DeleteAlarmsResult call() throws Exception {
                DeleteAlarmsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDeleteAlarms(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAnomalyDetectorResult> deleteAnomalyDetectorAsync(DeleteAnomalyDetectorRequest request) {
        return this.deleteAnomalyDetectorAsync(request, null);
    }

    @Override
    public Future<DeleteAnomalyDetectorResult> deleteAnomalyDetectorAsync(DeleteAnomalyDetectorRequest request, final AsyncHandler<DeleteAnomalyDetectorRequest, DeleteAnomalyDetectorResult> asyncHandler) {
        final DeleteAnomalyDetectorRequest finalRequest = (DeleteAnomalyDetectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAnomalyDetectorResult>(){

            @Override
            public DeleteAnomalyDetectorResult call() throws Exception {
                DeleteAnomalyDetectorResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDeleteAnomalyDetector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDashboardsResult> deleteDashboardsAsync(DeleteDashboardsRequest request) {
        return this.deleteDashboardsAsync(request, null);
    }

    @Override
    public Future<DeleteDashboardsResult> deleteDashboardsAsync(DeleteDashboardsRequest request, final AsyncHandler<DeleteDashboardsRequest, DeleteDashboardsResult> asyncHandler) {
        final DeleteDashboardsRequest finalRequest = (DeleteDashboardsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDashboardsResult>(){

            @Override
            public DeleteDashboardsResult call() throws Exception {
                DeleteDashboardsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDeleteDashboards(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteInsightRulesResult> deleteInsightRulesAsync(DeleteInsightRulesRequest request) {
        return this.deleteInsightRulesAsync(request, null);
    }

    @Override
    public Future<DeleteInsightRulesResult> deleteInsightRulesAsync(DeleteInsightRulesRequest request, final AsyncHandler<DeleteInsightRulesRequest, DeleteInsightRulesResult> asyncHandler) {
        final DeleteInsightRulesRequest finalRequest = (DeleteInsightRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteInsightRulesResult>(){

            @Override
            public DeleteInsightRulesResult call() throws Exception {
                DeleteInsightRulesResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDeleteInsightRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMetricStreamResult> deleteMetricStreamAsync(DeleteMetricStreamRequest request) {
        return this.deleteMetricStreamAsync(request, null);
    }

    @Override
    public Future<DeleteMetricStreamResult> deleteMetricStreamAsync(DeleteMetricStreamRequest request, final AsyncHandler<DeleteMetricStreamRequest, DeleteMetricStreamResult> asyncHandler) {
        final DeleteMetricStreamRequest finalRequest = (DeleteMetricStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMetricStreamResult>(){

            @Override
            public DeleteMetricStreamResult call() throws Exception {
                DeleteMetricStreamResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDeleteMetricStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync(DescribeAlarmHistoryRequest request) {
        return this.describeAlarmHistoryAsync(request, null);
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync(DescribeAlarmHistoryRequest request, final AsyncHandler<DescribeAlarmHistoryRequest, DescribeAlarmHistoryResult> asyncHandler) {
        final DescribeAlarmHistoryRequest finalRequest = (DescribeAlarmHistoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAlarmHistoryResult>(){

            @Override
            public DescribeAlarmHistoryResult call() throws Exception {
                DescribeAlarmHistoryResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDescribeAlarmHistory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync() {
        return this.describeAlarmHistoryAsync(new DescribeAlarmHistoryRequest());
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync(AsyncHandler<DescribeAlarmHistoryRequest, DescribeAlarmHistoryResult> asyncHandler) {
        return this.describeAlarmHistoryAsync(new DescribeAlarmHistoryRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync(DescribeAlarmsRequest request) {
        return this.describeAlarmsAsync(request, null);
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync(DescribeAlarmsRequest request, final AsyncHandler<DescribeAlarmsRequest, DescribeAlarmsResult> asyncHandler) {
        final DescribeAlarmsRequest finalRequest = (DescribeAlarmsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAlarmsResult>(){

            @Override
            public DescribeAlarmsResult call() throws Exception {
                DescribeAlarmsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDescribeAlarms(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync() {
        return this.describeAlarmsAsync(new DescribeAlarmsRequest());
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync(AsyncHandler<DescribeAlarmsRequest, DescribeAlarmsResult> asyncHandler) {
        return this.describeAlarmsAsync(new DescribeAlarmsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeAlarmsForMetricResult> describeAlarmsForMetricAsync(DescribeAlarmsForMetricRequest request) {
        return this.describeAlarmsForMetricAsync(request, null);
    }

    @Override
    public Future<DescribeAlarmsForMetricResult> describeAlarmsForMetricAsync(DescribeAlarmsForMetricRequest request, final AsyncHandler<DescribeAlarmsForMetricRequest, DescribeAlarmsForMetricResult> asyncHandler) {
        final DescribeAlarmsForMetricRequest finalRequest = (DescribeAlarmsForMetricRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAlarmsForMetricResult>(){

            @Override
            public DescribeAlarmsForMetricResult call() throws Exception {
                DescribeAlarmsForMetricResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDescribeAlarmsForMetric(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAnomalyDetectorsResult> describeAnomalyDetectorsAsync(DescribeAnomalyDetectorsRequest request) {
        return this.describeAnomalyDetectorsAsync(request, null);
    }

    @Override
    public Future<DescribeAnomalyDetectorsResult> describeAnomalyDetectorsAsync(DescribeAnomalyDetectorsRequest request, final AsyncHandler<DescribeAnomalyDetectorsRequest, DescribeAnomalyDetectorsResult> asyncHandler) {
        final DescribeAnomalyDetectorsRequest finalRequest = (DescribeAnomalyDetectorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAnomalyDetectorsResult>(){

            @Override
            public DescribeAnomalyDetectorsResult call() throws Exception {
                DescribeAnomalyDetectorsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDescribeAnomalyDetectors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInsightRulesResult> describeInsightRulesAsync(DescribeInsightRulesRequest request) {
        return this.describeInsightRulesAsync(request, null);
    }

    @Override
    public Future<DescribeInsightRulesResult> describeInsightRulesAsync(DescribeInsightRulesRequest request, final AsyncHandler<DescribeInsightRulesRequest, DescribeInsightRulesResult> asyncHandler) {
        final DescribeInsightRulesRequest finalRequest = (DescribeInsightRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeInsightRulesResult>(){

            @Override
            public DescribeInsightRulesResult call() throws Exception {
                DescribeInsightRulesResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDescribeInsightRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableAlarmActionsResult> disableAlarmActionsAsync(DisableAlarmActionsRequest request) {
        return this.disableAlarmActionsAsync(request, null);
    }

    @Override
    public Future<DisableAlarmActionsResult> disableAlarmActionsAsync(DisableAlarmActionsRequest request, final AsyncHandler<DisableAlarmActionsRequest, DisableAlarmActionsResult> asyncHandler) {
        final DisableAlarmActionsRequest finalRequest = (DisableAlarmActionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableAlarmActionsResult>(){

            @Override
            public DisableAlarmActionsResult call() throws Exception {
                DisableAlarmActionsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDisableAlarmActions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableInsightRulesResult> disableInsightRulesAsync(DisableInsightRulesRequest request) {
        return this.disableInsightRulesAsync(request, null);
    }

    @Override
    public Future<DisableInsightRulesResult> disableInsightRulesAsync(DisableInsightRulesRequest request, final AsyncHandler<DisableInsightRulesRequest, DisableInsightRulesResult> asyncHandler) {
        final DisableInsightRulesRequest finalRequest = (DisableInsightRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableInsightRulesResult>(){

            @Override
            public DisableInsightRulesResult call() throws Exception {
                DisableInsightRulesResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDisableInsightRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableAlarmActionsResult> enableAlarmActionsAsync(EnableAlarmActionsRequest request) {
        return this.enableAlarmActionsAsync(request, null);
    }

    @Override
    public Future<EnableAlarmActionsResult> enableAlarmActionsAsync(EnableAlarmActionsRequest request, final AsyncHandler<EnableAlarmActionsRequest, EnableAlarmActionsResult> asyncHandler) {
        final EnableAlarmActionsRequest finalRequest = (EnableAlarmActionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableAlarmActionsResult>(){

            @Override
            public EnableAlarmActionsResult call() throws Exception {
                EnableAlarmActionsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeEnableAlarmActions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableInsightRulesResult> enableInsightRulesAsync(EnableInsightRulesRequest request) {
        return this.enableInsightRulesAsync(request, null);
    }

    @Override
    public Future<EnableInsightRulesResult> enableInsightRulesAsync(EnableInsightRulesRequest request, final AsyncHandler<EnableInsightRulesRequest, EnableInsightRulesResult> asyncHandler) {
        final EnableInsightRulesRequest finalRequest = (EnableInsightRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableInsightRulesResult>(){

            @Override
            public EnableInsightRulesResult call() throws Exception {
                EnableInsightRulesResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeEnableInsightRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDashboardResult> getDashboardAsync(GetDashboardRequest request) {
        return this.getDashboardAsync(request, null);
    }

    @Override
    public Future<GetDashboardResult> getDashboardAsync(GetDashboardRequest request, final AsyncHandler<GetDashboardRequest, GetDashboardResult> asyncHandler) {
        final GetDashboardRequest finalRequest = (GetDashboardRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDashboardResult>(){

            @Override
            public GetDashboardResult call() throws Exception {
                GetDashboardResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeGetDashboard(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInsightRuleReportResult> getInsightRuleReportAsync(GetInsightRuleReportRequest request) {
        return this.getInsightRuleReportAsync(request, null);
    }

    @Override
    public Future<GetInsightRuleReportResult> getInsightRuleReportAsync(GetInsightRuleReportRequest request, final AsyncHandler<GetInsightRuleReportRequest, GetInsightRuleReportResult> asyncHandler) {
        final GetInsightRuleReportRequest finalRequest = (GetInsightRuleReportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInsightRuleReportResult>(){

            @Override
            public GetInsightRuleReportResult call() throws Exception {
                GetInsightRuleReportResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeGetInsightRuleReport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMetricDataResult> getMetricDataAsync(GetMetricDataRequest request) {
        return this.getMetricDataAsync(request, null);
    }

    @Override
    public Future<GetMetricDataResult> getMetricDataAsync(GetMetricDataRequest request, final AsyncHandler<GetMetricDataRequest, GetMetricDataResult> asyncHandler) {
        final GetMetricDataRequest finalRequest = (GetMetricDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMetricDataResult>(){

            @Override
            public GetMetricDataResult call() throws Exception {
                GetMetricDataResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeGetMetricData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMetricStatisticsResult> getMetricStatisticsAsync(GetMetricStatisticsRequest request) {
        return this.getMetricStatisticsAsync(request, null);
    }

    @Override
    public Future<GetMetricStatisticsResult> getMetricStatisticsAsync(GetMetricStatisticsRequest request, final AsyncHandler<GetMetricStatisticsRequest, GetMetricStatisticsResult> asyncHandler) {
        final GetMetricStatisticsRequest finalRequest = (GetMetricStatisticsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMetricStatisticsResult>(){

            @Override
            public GetMetricStatisticsResult call() throws Exception {
                GetMetricStatisticsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeGetMetricStatistics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMetricStreamResult> getMetricStreamAsync(GetMetricStreamRequest request) {
        return this.getMetricStreamAsync(request, null);
    }

    @Override
    public Future<GetMetricStreamResult> getMetricStreamAsync(GetMetricStreamRequest request, final AsyncHandler<GetMetricStreamRequest, GetMetricStreamResult> asyncHandler) {
        final GetMetricStreamRequest finalRequest = (GetMetricStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMetricStreamResult>(){

            @Override
            public GetMetricStreamResult call() throws Exception {
                GetMetricStreamResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeGetMetricStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMetricWidgetImageResult> getMetricWidgetImageAsync(GetMetricWidgetImageRequest request) {
        return this.getMetricWidgetImageAsync(request, null);
    }

    @Override
    public Future<GetMetricWidgetImageResult> getMetricWidgetImageAsync(GetMetricWidgetImageRequest request, final AsyncHandler<GetMetricWidgetImageRequest, GetMetricWidgetImageResult> asyncHandler) {
        final GetMetricWidgetImageRequest finalRequest = (GetMetricWidgetImageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMetricWidgetImageResult>(){

            @Override
            public GetMetricWidgetImageResult call() throws Exception {
                GetMetricWidgetImageResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeGetMetricWidgetImage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDashboardsResult> listDashboardsAsync(ListDashboardsRequest request) {
        return this.listDashboardsAsync(request, null);
    }

    @Override
    public Future<ListDashboardsResult> listDashboardsAsync(ListDashboardsRequest request, final AsyncHandler<ListDashboardsRequest, ListDashboardsResult> asyncHandler) {
        final ListDashboardsRequest finalRequest = (ListDashboardsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDashboardsResult>(){

            @Override
            public ListDashboardsResult call() throws Exception {
                ListDashboardsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeListDashboards(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMetricStreamsResult> listMetricStreamsAsync(ListMetricStreamsRequest request) {
        return this.listMetricStreamsAsync(request, null);
    }

    @Override
    public Future<ListMetricStreamsResult> listMetricStreamsAsync(ListMetricStreamsRequest request, final AsyncHandler<ListMetricStreamsRequest, ListMetricStreamsResult> asyncHandler) {
        final ListMetricStreamsRequest finalRequest = (ListMetricStreamsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMetricStreamsResult>(){

            @Override
            public ListMetricStreamsResult call() throws Exception {
                ListMetricStreamsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeListMetricStreams(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync(ListMetricsRequest request) {
        return this.listMetricsAsync(request, null);
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync(ListMetricsRequest request, final AsyncHandler<ListMetricsRequest, ListMetricsResult> asyncHandler) {
        final ListMetricsRequest finalRequest = (ListMetricsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMetricsResult>(){

            @Override
            public ListMetricsResult call() throws Exception {
                ListMetricsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeListMetrics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync() {
        return this.listMetricsAsync(new ListMetricsRequest());
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync(AsyncHandler<ListMetricsRequest, ListMetricsResult> asyncHandler) {
        return this.listMetricsAsync(new ListMetricsRequest(), asyncHandler);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutAnomalyDetectorResult> putAnomalyDetectorAsync(PutAnomalyDetectorRequest request) {
        return this.putAnomalyDetectorAsync(request, null);
    }

    @Override
    public Future<PutAnomalyDetectorResult> putAnomalyDetectorAsync(PutAnomalyDetectorRequest request, final AsyncHandler<PutAnomalyDetectorRequest, PutAnomalyDetectorResult> asyncHandler) {
        final PutAnomalyDetectorRequest finalRequest = (PutAnomalyDetectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutAnomalyDetectorResult>(){

            @Override
            public PutAnomalyDetectorResult call() throws Exception {
                PutAnomalyDetectorResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executePutAnomalyDetector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutCompositeAlarmResult> putCompositeAlarmAsync(PutCompositeAlarmRequest request) {
        return this.putCompositeAlarmAsync(request, null);
    }

    @Override
    public Future<PutCompositeAlarmResult> putCompositeAlarmAsync(PutCompositeAlarmRequest request, final AsyncHandler<PutCompositeAlarmRequest, PutCompositeAlarmResult> asyncHandler) {
        final PutCompositeAlarmRequest finalRequest = (PutCompositeAlarmRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutCompositeAlarmResult>(){

            @Override
            public PutCompositeAlarmResult call() throws Exception {
                PutCompositeAlarmResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executePutCompositeAlarm(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutDashboardResult> putDashboardAsync(PutDashboardRequest request) {
        return this.putDashboardAsync(request, null);
    }

    @Override
    public Future<PutDashboardResult> putDashboardAsync(PutDashboardRequest request, final AsyncHandler<PutDashboardRequest, PutDashboardResult> asyncHandler) {
        final PutDashboardRequest finalRequest = (PutDashboardRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutDashboardResult>(){

            @Override
            public PutDashboardResult call() throws Exception {
                PutDashboardResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executePutDashboard(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutInsightRuleResult> putInsightRuleAsync(PutInsightRuleRequest request) {
        return this.putInsightRuleAsync(request, null);
    }

    @Override
    public Future<PutInsightRuleResult> putInsightRuleAsync(PutInsightRuleRequest request, final AsyncHandler<PutInsightRuleRequest, PutInsightRuleResult> asyncHandler) {
        final PutInsightRuleRequest finalRequest = (PutInsightRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutInsightRuleResult>(){

            @Override
            public PutInsightRuleResult call() throws Exception {
                PutInsightRuleResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executePutInsightRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutMetricAlarmResult> putMetricAlarmAsync(PutMetricAlarmRequest request) {
        return this.putMetricAlarmAsync(request, null);
    }

    @Override
    public Future<PutMetricAlarmResult> putMetricAlarmAsync(PutMetricAlarmRequest request, final AsyncHandler<PutMetricAlarmRequest, PutMetricAlarmResult> asyncHandler) {
        final PutMetricAlarmRequest finalRequest = (PutMetricAlarmRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutMetricAlarmResult>(){

            @Override
            public PutMetricAlarmResult call() throws Exception {
                PutMetricAlarmResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executePutMetricAlarm(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutMetricDataResult> putMetricDataAsync(PutMetricDataRequest request) {
        return this.putMetricDataAsync(request, null);
    }

    @Override
    public Future<PutMetricDataResult> putMetricDataAsync(PutMetricDataRequest request, final AsyncHandler<PutMetricDataRequest, PutMetricDataResult> asyncHandler) {
        final PutMetricDataRequest finalRequest = (PutMetricDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutMetricDataResult>(){

            @Override
            public PutMetricDataResult call() throws Exception {
                PutMetricDataResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executePutMetricData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutMetricStreamResult> putMetricStreamAsync(PutMetricStreamRequest request) {
        return this.putMetricStreamAsync(request, null);
    }

    @Override
    public Future<PutMetricStreamResult> putMetricStreamAsync(PutMetricStreamRequest request, final AsyncHandler<PutMetricStreamRequest, PutMetricStreamResult> asyncHandler) {
        final PutMetricStreamRequest finalRequest = (PutMetricStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutMetricStreamResult>(){

            @Override
            public PutMetricStreamResult call() throws Exception {
                PutMetricStreamResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executePutMetricStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetAlarmStateResult> setAlarmStateAsync(SetAlarmStateRequest request) {
        return this.setAlarmStateAsync(request, null);
    }

    @Override
    public Future<SetAlarmStateResult> setAlarmStateAsync(SetAlarmStateRequest request, final AsyncHandler<SetAlarmStateRequest, SetAlarmStateResult> asyncHandler) {
        final SetAlarmStateRequest finalRequest = (SetAlarmStateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SetAlarmStateResult>(){

            @Override
            public SetAlarmStateResult call() throws Exception {
                SetAlarmStateResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeSetAlarmState(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartMetricStreamsResult> startMetricStreamsAsync(StartMetricStreamsRequest request) {
        return this.startMetricStreamsAsync(request, null);
    }

    @Override
    public Future<StartMetricStreamsResult> startMetricStreamsAsync(StartMetricStreamsRequest request, final AsyncHandler<StartMetricStreamsRequest, StartMetricStreamsResult> asyncHandler) {
        final StartMetricStreamsRequest finalRequest = (StartMetricStreamsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartMetricStreamsResult>(){

            @Override
            public StartMetricStreamsResult call() throws Exception {
                StartMetricStreamsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeStartMetricStreams(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopMetricStreamsResult> stopMetricStreamsAsync(StopMetricStreamsRequest request) {
        return this.stopMetricStreamsAsync(request, null);
    }

    @Override
    public Future<StopMetricStreamsResult> stopMetricStreamsAsync(StopMetricStreamsRequest request, final AsyncHandler<StopMetricStreamsRequest, StopMetricStreamsResult> asyncHandler) {
        final StopMetricStreamsRequest finalRequest = (StopMetricStreamsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopMetricStreamsResult>(){

            @Override
            public StopMetricStreamsResult call() throws Exception {
                StopMetricStreamsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeStopMetricStreams(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

