/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.QueryStringNames;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class QueryStringNamesStaxUnmarshaller
implements Unmarshaller<QueryStringNames, StaxUnmarshallerContext> {
    private static QueryStringNamesStaxUnmarshaller instance;

    public QueryStringNames unmarshall(StaxUnmarshallerContext context) throws Exception {
        QueryStringNames queryStringNames = new QueryStringNames();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return queryStringNames;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    queryStringNames.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    queryStringNames.withItems(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Items/Name", targetDepth)) continue;
                queryStringNames.withItems(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return queryStringNames;
    }

    public static QueryStringNamesStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new QueryStringNamesStaxUnmarshaller();
        }
        return instance;
    }
}

