/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.Tag;
import com.amazonaws.services.cloudfront.model.Tags;
import com.amazonaws.services.cloudfront.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class TagsStaxUnmarshaller
implements Unmarshaller<Tags, StaxUnmarshallerContext> {
    private static TagsStaxUnmarshaller instance;

    public Tags unmarshall(StaxUnmarshallerContext context) throws Exception {
        Tags tags = new Tags();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return tags;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Items", targetDepth)) {
                    tags.withItems(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("Items/Tag", targetDepth)) continue;
                tags.withItems(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return tags;
    }

    public static TagsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TagsStaxUnmarshaller();
        }
        return instance;
    }
}

