/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.StreamingDistributionConfig;
import com.amazonaws.services.cloudfront.model.transform.AliasesStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.S3OriginStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.StreamingLoggingConfigStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.TrustedSignersStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class StreamingDistributionConfigStaxUnmarshaller
implements Unmarshaller<StreamingDistributionConfig, StaxUnmarshallerContext> {
    private static StreamingDistributionConfigStaxUnmarshaller instance;

    public StreamingDistributionConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        StreamingDistributionConfig streamingDistributionConfig = new StreamingDistributionConfig();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return streamingDistributionConfig;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CallerReference", targetDepth)) {
                    streamingDistributionConfig.setCallerReference(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("S3Origin", targetDepth)) {
                    streamingDistributionConfig.setS3Origin(S3OriginStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Aliases", targetDepth)) {
                    streamingDistributionConfig.setAliases(AliasesStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Comment", targetDepth)) {
                    streamingDistributionConfig.setComment(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Logging", targetDepth)) {
                    streamingDistributionConfig.setLogging(StreamingLoggingConfigStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TrustedSigners", targetDepth)) {
                    streamingDistributionConfig.setTrustedSigners(TrustedSignersStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PriceClass", targetDepth)) {
                    streamingDistributionConfig.setPriceClass(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Enabled", targetDepth)) continue;
                streamingDistributionConfig.setEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return streamingDistributionConfig;
    }

    public static StreamingDistributionConfigStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new StreamingDistributionConfigStaxUnmarshaller();
        }
        return instance;
    }
}

