/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.pi.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A logical grouping of Performance Insights metrics for a related subject area. For example, the <code>db.sql</code>
 * dimension group consists of the following dimensions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>db.sql.id</code> - The hash of a running SQL statement, generated by Performance Insights.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by Performance
 * Insights that begins with <code>pi-</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>db.sql.statement</code> - The full text of the SQL statement that is running, for example,
 * <code>SELECT * FROM employees</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights.
 * </p>
 * </li>
 * </ul>
 * <note>
 * <p>
 * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500
 * bytes are returned.
 * </p>
 * </note>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/DimensionGroup" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DimensionGroup implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the dimension group. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db</code> - The name of the database to which the client is connected. The following values are permitted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MariaDB
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.application</code> - The name of the application that is connected to the database. The following values
     * are permitted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.host</code> - The host name of the connected client (all engines).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query</code> - The query that is currently running (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query_tokenized</code> - The digest query (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql</code> - The text of the SQL statement that is currently running (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized</code> - The SQL digest (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user</code> - The user logged in to the database (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event</code> - The event for which the database backend is waiting (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines except
     * Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_state</code> - The event for which the database backend is waiting (only Amazon DocumentDB).
     * </p>
     * </li>
     * </ul>
     */
    private String group;
    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that
     * all of the dimensions in the group were requested, or are present in the response.
     * </p>
     * <p>
     * Valid values for elements in the <code>Dimensions</code> array are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db.application.name</code> - The name of the application that is connected to the database. Valid values
     * are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.host.id</code> - The host ID of the connected client (all engines).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host.name</code> - The host name of the connected client (all engines).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.name</code> - The name of the database to which the client is connected. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MariaDB
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.query.id</code> - The query ID generated by Performance Insights (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.db_id</code> - The query ID generated by the database (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.statement</code> - The text of the query that is being run (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized.id</code> - The query digest ID generated by Performance Insights (only Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized.db_id</code> - The query digest ID generated by Performance Insights (only Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized.statement</code> - The text of the query digest (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type.name</code> - The type of the current session (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.id</code> - The hash of the full, non-tokenized SQL statement generated by Performance Insights (all
     * engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by
     * Performance Insights that begins with <code>pi-</code> (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.statement</code> - The full text of the SQL statement that is running, as in
     * <code>SELECT * FROM employees</code> (all engines except Amazon DocumentDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.tokenized_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights (all engines
     * except Amazon DocumentDB). In the console, <code>db.sql_tokenized.id</code> is called the Support ID because
     * Amazon Web Services Support can look at this data to help you troubleshoot database issues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.db_id</code> - Either the native database ID used to refer to the SQL statement, or a
     * synthetic ID such as <code>pi-2372568224</code> that Performance Insights generates if the native database ID
     * isn't available (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.statement</code> - The text of the SQL digest, as in
     * <code>SELECT * FROM employees WHERE employee_id = ?</code> (all engines except Amazon DocumentDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.id</code> - The ID of the user logged in to the database (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.name</code> - The name of the user logged in to the database (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines
     * except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_state.name</code> - The event for which the backend is waiting (only Amazon DocumentDB).
     * </p>
     * </li>
     * </ul>
     */
    private java.util.List<String> dimensions;
    /**
     * <p>
     * The maximum number of items to fetch for this dimension group.
     * </p>
     */
    private Integer limit;

    /**
     * <p>
     * The name of the dimension group. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db</code> - The name of the database to which the client is connected. The following values are permitted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MariaDB
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.application</code> - The name of the application that is connected to the database. The following values
     * are permitted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.host</code> - The host name of the connected client (all engines).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query</code> - The query that is currently running (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query_tokenized</code> - The digest query (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql</code> - The text of the SQL statement that is currently running (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized</code> - The SQL digest (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user</code> - The user logged in to the database (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event</code> - The event for which the database backend is waiting (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines except
     * Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_state</code> - The event for which the database backend is waiting (only Amazon DocumentDB).
     * </p>
     * </li>
     * </ul>
     * 
     * @param group
     *        The name of the dimension group. Valid values are as follows:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>db</code> - The name of the database to which the client is connected. The following values are
     *        permitted:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Aurora PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Aurora MySQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS MySQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS MariaDB
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon DocumentDB
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.application</code> - The name of the application that is connected to the database. The following
     *        values are permitted:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Aurora PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon DocumentDB
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host</code> - The host name of the connected client (all engines).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query</code> - The query that is currently running (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query_tokenized</code> - The digest query (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS
     *        PostgreSQL).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql</code> - The text of the SQL statement that is currently running (all engines except Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized</code> - The SQL digest (all engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user</code> - The user logged in to the database (all engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event</code> - The event for which the database backend is waiting (all engines except
     *        Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines
     *        except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_state</code> - The event for which the database backend is waiting (only Amazon DocumentDB).
     *        </p>
     *        </li>
     */

    public void setGroup(String group) {
        this.group = group;
    }

    /**
     * <p>
     * The name of the dimension group. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db</code> - The name of the database to which the client is connected. The following values are permitted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MariaDB
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.application</code> - The name of the application that is connected to the database. The following values
     * are permitted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.host</code> - The host name of the connected client (all engines).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query</code> - The query that is currently running (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query_tokenized</code> - The digest query (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql</code> - The text of the SQL statement that is currently running (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized</code> - The SQL digest (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user</code> - The user logged in to the database (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event</code> - The event for which the database backend is waiting (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines except
     * Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_state</code> - The event for which the database backend is waiting (only Amazon DocumentDB).
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the dimension group. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>db</code> - The name of the database to which the client is connected. The following values are
     *         permitted:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aurora PostgreSQL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon RDS PostgreSQL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Aurora MySQL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon RDS MySQL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon RDS MariaDB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon DocumentDB
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.application</code> - The name of the application that is connected to the database. The
     *         following values are permitted:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aurora PostgreSQL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon RDS PostgreSQL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon DocumentDB
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.host</code> - The host name of the connected client (all engines).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.query</code> - The query that is currently running (only Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.query_tokenized</code> - The digest query (only Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS
     *         PostgreSQL).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql</code> - The text of the SQL statement that is currently running (all engines except Amazon
     *         DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql_tokenized</code> - The SQL digest (all engines except Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.user</code> - The user logged in to the database (all engines except Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.wait_event</code> - The event for which the database backend is waiting (all engines except
     *         Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all
     *         engines except Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.wait_state</code> - The event for which the database backend is waiting (only Amazon
     *         DocumentDB).
     *         </p>
     *         </li>
     */

    public String getGroup() {
        return this.group;
    }

    /**
     * <p>
     * The name of the dimension group. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db</code> - The name of the database to which the client is connected. The following values are permitted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MariaDB
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.application</code> - The name of the application that is connected to the database. The following values
     * are permitted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.host</code> - The host name of the connected client (all engines).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query</code> - The query that is currently running (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query_tokenized</code> - The digest query (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql</code> - The text of the SQL statement that is currently running (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized</code> - The SQL digest (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user</code> - The user logged in to the database (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event</code> - The event for which the database backend is waiting (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines except
     * Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_state</code> - The event for which the database backend is waiting (only Amazon DocumentDB).
     * </p>
     * </li>
     * </ul>
     * 
     * @param group
     *        The name of the dimension group. Valid values are as follows:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>db</code> - The name of the database to which the client is connected. The following values are
     *        permitted:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Aurora PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Aurora MySQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS MySQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS MariaDB
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon DocumentDB
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.application</code> - The name of the application that is connected to the database. The following
     *        values are permitted:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Aurora PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon DocumentDB
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host</code> - The host name of the connected client (all engines).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query</code> - The query that is currently running (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query_tokenized</code> - The digest query (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS
     *        PostgreSQL).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql</code> - The text of the SQL statement that is currently running (all engines except Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized</code> - The SQL digest (all engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user</code> - The user logged in to the database (all engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event</code> - The event for which the database backend is waiting (all engines except
     *        Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines
     *        except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_state</code> - The event for which the database backend is waiting (only Amazon DocumentDB).
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DimensionGroup withGroup(String group) {
        setGroup(group);
        return this;
    }

    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that
     * all of the dimensions in the group were requested, or are present in the response.
     * </p>
     * <p>
     * Valid values for elements in the <code>Dimensions</code> array are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db.application.name</code> - The name of the application that is connected to the database. Valid values
     * are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.host.id</code> - The host ID of the connected client (all engines).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host.name</code> - The host name of the connected client (all engines).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.name</code> - The name of the database to which the client is connected. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MariaDB
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.query.id</code> - The query ID generated by Performance Insights (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.db_id</code> - The query ID generated by the database (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.statement</code> - The text of the query that is being run (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized.id</code> - The query digest ID generated by Performance Insights (only Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized.db_id</code> - The query digest ID generated by Performance Insights (only Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized.statement</code> - The text of the query digest (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type.name</code> - The type of the current session (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.id</code> - The hash of the full, non-tokenized SQL statement generated by Performance Insights (all
     * engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by
     * Performance Insights that begins with <code>pi-</code> (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.statement</code> - The full text of the SQL statement that is running, as in
     * <code>SELECT * FROM employees</code> (all engines except Amazon DocumentDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.tokenized_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights (all engines
     * except Amazon DocumentDB). In the console, <code>db.sql_tokenized.id</code> is called the Support ID because
     * Amazon Web Services Support can look at this data to help you troubleshoot database issues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.db_id</code> - Either the native database ID used to refer to the SQL statement, or a
     * synthetic ID such as <code>pi-2372568224</code> that Performance Insights generates if the native database ID
     * isn't available (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.statement</code> - The text of the SQL digest, as in
     * <code>SELECT * FROM employees WHERE employee_id = ?</code> (all engines except Amazon DocumentDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.id</code> - The ID of the user logged in to the database (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.name</code> - The name of the user logged in to the database (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines
     * except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_state.name</code> - The event for which the backend is waiting (only Amazon DocumentDB).
     * </p>
     * </li>
     * </ul>
     * 
     * @return A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies
     *         that all of the dimensions in the group were requested, or are present in the response.</p>
     *         <p>
     *         Valid values for elements in the <code>Dimensions</code> array are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>db.application.name</code> - The name of the application that is connected to the database. Valid
     *         values are as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aurora PostgreSQL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon RDS PostgreSQL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon DocumentDB
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.host.id</code> - The host ID of the connected client (all engines).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.host.name</code> - The host name of the connected client (all engines).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.name</code> - The name of the database to which the client is connected. Valid values are as
     *         follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aurora PostgreSQL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon RDS PostgreSQL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Aurora MySQL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon RDS MySQL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon RDS MariaDB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon DocumentDB
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.query.id</code> - The query ID generated by Performance Insights (only Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.query.db_id</code> - The query ID generated by the database (only Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.query.statement</code> - The text of the query that is being run (only Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.query.tokenized_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.query.tokenized.id</code> - The query digest ID generated by Performance Insights (only Amazon
     *         DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.query.tokenized.db_id</code> - The query digest ID generated by Performance Insights (only
     *         Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.query.tokenized.statement</code> - The text of the query digest (only Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.session_type.name</code> - The type of the current session (only Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql.id</code> - The hash of the full, non-tokenized SQL statement generated by Performance
     *         Insights (all engines except Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by
     *         Performance Insights that begins with <code>pi-</code> (all engines except Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql.statement</code> - The full text of the SQL statement that is running, as in
     *         <code>SELECT * FROM employees</code> (all engines except Amazon DocumentDB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql.tokenized_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights (all
     *         engines except Amazon DocumentDB). In the console, <code>db.sql_tokenized.id</code> is called the Support
     *         ID because Amazon Web Services Support can look at this data to help you troubleshoot database issues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql_tokenized.db_id</code> - Either the native database ID used to refer to the SQL statement,
     *         or a synthetic ID such as <code>pi-2372568224</code> that Performance Insights generates if the native
     *         database ID isn't available (all engines except Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql_tokenized.statement</code> - The text of the SQL digest, as in
     *         <code>SELECT * FROM employees WHERE employee_id = ?</code> (all engines except Amazon DocumentDB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.user.id</code> - The ID of the user logged in to the database (all engines except Amazon
     *         DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.user.name</code> - The name of the user logged in to the database (all engines except Amazon
     *         DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines except Amazon
     *         DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines except
     *         Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all
     *         engines except Amazon DocumentDB).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.wait_state.name</code> - The event for which the backend is waiting (only Amazon DocumentDB).
     *         </p>
     *         </li>
     */

    public java.util.List<String> getDimensions() {
        return dimensions;
    }

    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that
     * all of the dimensions in the group were requested, or are present in the response.
     * </p>
     * <p>
     * Valid values for elements in the <code>Dimensions</code> array are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db.application.name</code> - The name of the application that is connected to the database. Valid values
     * are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.host.id</code> - The host ID of the connected client (all engines).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host.name</code> - The host name of the connected client (all engines).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.name</code> - The name of the database to which the client is connected. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MariaDB
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.query.id</code> - The query ID generated by Performance Insights (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.db_id</code> - The query ID generated by the database (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.statement</code> - The text of the query that is being run (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized.id</code> - The query digest ID generated by Performance Insights (only Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized.db_id</code> - The query digest ID generated by Performance Insights (only Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized.statement</code> - The text of the query digest (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type.name</code> - The type of the current session (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.id</code> - The hash of the full, non-tokenized SQL statement generated by Performance Insights (all
     * engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by
     * Performance Insights that begins with <code>pi-</code> (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.statement</code> - The full text of the SQL statement that is running, as in
     * <code>SELECT * FROM employees</code> (all engines except Amazon DocumentDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.tokenized_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights (all engines
     * except Amazon DocumentDB). In the console, <code>db.sql_tokenized.id</code> is called the Support ID because
     * Amazon Web Services Support can look at this data to help you troubleshoot database issues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.db_id</code> - Either the native database ID used to refer to the SQL statement, or a
     * synthetic ID such as <code>pi-2372568224</code> that Performance Insights generates if the native database ID
     * isn't available (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.statement</code> - The text of the SQL digest, as in
     * <code>SELECT * FROM employees WHERE employee_id = ?</code> (all engines except Amazon DocumentDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.id</code> - The ID of the user logged in to the database (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.name</code> - The name of the user logged in to the database (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines
     * except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_state.name</code> - The event for which the backend is waiting (only Amazon DocumentDB).
     * </p>
     * </li>
     * </ul>
     * 
     * @param dimensions
     *        A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies
     *        that all of the dimensions in the group were requested, or are present in the response.</p>
     *        <p>
     *        Valid values for elements in the <code>Dimensions</code> array are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>db.application.name</code> - The name of the application that is connected to the database. Valid
     *        values are as follows:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Aurora PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon DocumentDB
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host.id</code> - The host ID of the connected client (all engines).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host.name</code> - The host name of the connected client (all engines).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.name</code> - The name of the database to which the client is connected. Valid values are as
     *        follows:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Aurora PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Aurora MySQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS MySQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS MariaDB
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon DocumentDB
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.id</code> - The query ID generated by Performance Insights (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.db_id</code> - The query ID generated by the database (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.statement</code> - The text of the query that is being run (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.tokenized_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.tokenized.id</code> - The query digest ID generated by Performance Insights (only Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.tokenized.db_id</code> - The query digest ID generated by Performance Insights (only Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.tokenized.statement</code> - The text of the query digest (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.session_type.name</code> - The type of the current session (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.id</code> - The hash of the full, non-tokenized SQL statement generated by Performance
     *        Insights (all engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by
     *        Performance Insights that begins with <code>pi-</code> (all engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.statement</code> - The full text of the SQL statement that is running, as in
     *        <code>SELECT * FROM employees</code> (all engines except Amazon DocumentDB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.tokenized_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights (all
     *        engines except Amazon DocumentDB). In the console, <code>db.sql_tokenized.id</code> is called the Support
     *        ID because Amazon Web Services Support can look at this data to help you troubleshoot database issues.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.db_id</code> - Either the native database ID used to refer to the SQL statement, or
     *        a synthetic ID such as <code>pi-2372568224</code> that Performance Insights generates if the native
     *        database ID isn't available (all engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.statement</code> - The text of the SQL digest, as in
     *        <code>SELECT * FROM employees WHERE employee_id = ?</code> (all engines except Amazon DocumentDB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user.id</code> - The ID of the user logged in to the database (all engines except Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user.name</code> - The name of the user logged in to the database (all engines except Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines except Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines except
     *        Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all
     *        engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_state.name</code> - The event for which the backend is waiting (only Amazon DocumentDB).
     *        </p>
     *        </li>
     */

    public void setDimensions(java.util.Collection<String> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }

        this.dimensions = new java.util.ArrayList<String>(dimensions);
    }

    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that
     * all of the dimensions in the group were requested, or are present in the response.
     * </p>
     * <p>
     * Valid values for elements in the <code>Dimensions</code> array are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db.application.name</code> - The name of the application that is connected to the database. Valid values
     * are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.host.id</code> - The host ID of the connected client (all engines).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host.name</code> - The host name of the connected client (all engines).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.name</code> - The name of the database to which the client is connected. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MariaDB
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.query.id</code> - The query ID generated by Performance Insights (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.db_id</code> - The query ID generated by the database (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.statement</code> - The text of the query that is being run (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized.id</code> - The query digest ID generated by Performance Insights (only Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized.db_id</code> - The query digest ID generated by Performance Insights (only Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized.statement</code> - The text of the query digest (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type.name</code> - The type of the current session (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.id</code> - The hash of the full, non-tokenized SQL statement generated by Performance Insights (all
     * engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by
     * Performance Insights that begins with <code>pi-</code> (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.statement</code> - The full text of the SQL statement that is running, as in
     * <code>SELECT * FROM employees</code> (all engines except Amazon DocumentDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.tokenized_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights (all engines
     * except Amazon DocumentDB). In the console, <code>db.sql_tokenized.id</code> is called the Support ID because
     * Amazon Web Services Support can look at this data to help you troubleshoot database issues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.db_id</code> - Either the native database ID used to refer to the SQL statement, or a
     * synthetic ID such as <code>pi-2372568224</code> that Performance Insights generates if the native database ID
     * isn't available (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.statement</code> - The text of the SQL digest, as in
     * <code>SELECT * FROM employees WHERE employee_id = ?</code> (all engines except Amazon DocumentDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.id</code> - The ID of the user logged in to the database (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.name</code> - The name of the user logged in to the database (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines
     * except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_state.name</code> - The event for which the backend is waiting (only Amazon DocumentDB).
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDimensions(java.util.Collection)} or {@link #withDimensions(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param dimensions
     *        A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies
     *        that all of the dimensions in the group were requested, or are present in the response.</p>
     *        <p>
     *        Valid values for elements in the <code>Dimensions</code> array are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>db.application.name</code> - The name of the application that is connected to the database. Valid
     *        values are as follows:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Aurora PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon DocumentDB
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host.id</code> - The host ID of the connected client (all engines).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host.name</code> - The host name of the connected client (all engines).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.name</code> - The name of the database to which the client is connected. Valid values are as
     *        follows:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Aurora PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Aurora MySQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS MySQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS MariaDB
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon DocumentDB
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.id</code> - The query ID generated by Performance Insights (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.db_id</code> - The query ID generated by the database (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.statement</code> - The text of the query that is being run (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.tokenized_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.tokenized.id</code> - The query digest ID generated by Performance Insights (only Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.tokenized.db_id</code> - The query digest ID generated by Performance Insights (only Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.tokenized.statement</code> - The text of the query digest (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.session_type.name</code> - The type of the current session (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.id</code> - The hash of the full, non-tokenized SQL statement generated by Performance
     *        Insights (all engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by
     *        Performance Insights that begins with <code>pi-</code> (all engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.statement</code> - The full text of the SQL statement that is running, as in
     *        <code>SELECT * FROM employees</code> (all engines except Amazon DocumentDB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.tokenized_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights (all
     *        engines except Amazon DocumentDB). In the console, <code>db.sql_tokenized.id</code> is called the Support
     *        ID because Amazon Web Services Support can look at this data to help you troubleshoot database issues.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.db_id</code> - Either the native database ID used to refer to the SQL statement, or
     *        a synthetic ID such as <code>pi-2372568224</code> that Performance Insights generates if the native
     *        database ID isn't available (all engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.statement</code> - The text of the SQL digest, as in
     *        <code>SELECT * FROM employees WHERE employee_id = ?</code> (all engines except Amazon DocumentDB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user.id</code> - The ID of the user logged in to the database (all engines except Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user.name</code> - The name of the user logged in to the database (all engines except Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines except Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines except
     *        Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all
     *        engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_state.name</code> - The event for which the backend is waiting (only Amazon DocumentDB).
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DimensionGroup withDimensions(String... dimensions) {
        if (this.dimensions == null) {
            setDimensions(new java.util.ArrayList<String>(dimensions.length));
        }
        for (String ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that
     * all of the dimensions in the group were requested, or are present in the response.
     * </p>
     * <p>
     * Valid values for elements in the <code>Dimensions</code> array are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db.application.name</code> - The name of the application that is connected to the database. Valid values
     * are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.host.id</code> - The host ID of the connected client (all engines).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host.name</code> - The host name of the connected client (all engines).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.name</code> - The name of the database to which the client is connected. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS PostgreSQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MySQL
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon RDS MariaDB
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>db.query.id</code> - The query ID generated by Performance Insights (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.db_id</code> - The query ID generated by the database (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.statement</code> - The text of the query that is being run (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized.id</code> - The query digest ID generated by Performance Insights (only Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized.db_id</code> - The query digest ID generated by Performance Insights (only Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.query.tokenized.statement</code> - The text of the query digest (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type.name</code> - The type of the current session (only Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.id</code> - The hash of the full, non-tokenized SQL statement generated by Performance Insights (all
     * engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by
     * Performance Insights that begins with <code>pi-</code> (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.statement</code> - The full text of the SQL statement that is running, as in
     * <code>SELECT * FROM employees</code> (all engines except Amazon DocumentDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.tokenized_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights (all engines
     * except Amazon DocumentDB). In the console, <code>db.sql_tokenized.id</code> is called the Support ID because
     * Amazon Web Services Support can look at this data to help you troubleshoot database issues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.db_id</code> - Either the native database ID used to refer to the SQL statement, or a
     * synthetic ID such as <code>pi-2372568224</code> that Performance Insights generates if the native database ID
     * isn't available (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.statement</code> - The text of the SQL digest, as in
     * <code>SELECT * FROM employees WHERE employee_id = ?</code> (all engines except Amazon DocumentDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.id</code> - The ID of the user logged in to the database (all engines except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.name</code> - The name of the user logged in to the database (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines except Amazon
     * DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines
     * except Amazon DocumentDB).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_state.name</code> - The event for which the backend is waiting (only Amazon DocumentDB).
     * </p>
     * </li>
     * </ul>
     * 
     * @param dimensions
     *        A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies
     *        that all of the dimensions in the group were requested, or are present in the response.</p>
     *        <p>
     *        Valid values for elements in the <code>Dimensions</code> array are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>db.application.name</code> - The name of the application that is connected to the database. Valid
     *        values are as follows:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Aurora PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon DocumentDB
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host.id</code> - The host ID of the connected client (all engines).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host.name</code> - The host name of the connected client (all engines).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.name</code> - The name of the database to which the client is connected. Valid values are as
     *        follows:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Aurora PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS PostgreSQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Aurora MySQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS MySQL
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon RDS MariaDB
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Amazon DocumentDB
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.id</code> - The query ID generated by Performance Insights (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.db_id</code> - The query ID generated by the database (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.statement</code> - The text of the query that is being run (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.tokenized_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.tokenized.id</code> - The query digest ID generated by Performance Insights (only Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.tokenized.db_id</code> - The query digest ID generated by Performance Insights (only Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.query.tokenized.statement</code> - The text of the query digest (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.session_type.name</code> - The type of the current session (only Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.id</code> - The hash of the full, non-tokenized SQL statement generated by Performance
     *        Insights (all engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by
     *        Performance Insights that begins with <code>pi-</code> (all engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.statement</code> - The full text of the SQL statement that is running, as in
     *        <code>SELECT * FROM employees</code> (all engines except Amazon DocumentDB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.tokenized_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights (all
     *        engines except Amazon DocumentDB). In the console, <code>db.sql_tokenized.id</code> is called the Support
     *        ID because Amazon Web Services Support can look at this data to help you troubleshoot database issues.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.db_id</code> - Either the native database ID used to refer to the SQL statement, or
     *        a synthetic ID such as <code>pi-2372568224</code> that Performance Insights generates if the native
     *        database ID isn't available (all engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.statement</code> - The text of the SQL digest, as in
     *        <code>SELECT * FROM employees WHERE employee_id = ?</code> (all engines except Amazon DocumentDB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user.id</code> - The ID of the user logged in to the database (all engines except Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user.name</code> - The name of the user logged in to the database (all engines except Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines except Amazon
     *        DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines except
     *        Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all
     *        engines except Amazon DocumentDB).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_state.name</code> - The event for which the backend is waiting (only Amazon DocumentDB).
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DimensionGroup withDimensions(java.util.Collection<String> dimensions) {
        setDimensions(dimensions);
        return this;
    }

    /**
     * <p>
     * The maximum number of items to fetch for this dimension group.
     * </p>
     * 
     * @param limit
     *        The maximum number of items to fetch for this dimension group.
     */

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    /**
     * <p>
     * The maximum number of items to fetch for this dimension group.
     * </p>
     * 
     * @return The maximum number of items to fetch for this dimension group.
     */

    public Integer getLimit() {
        return this.limit;
    }

    /**
     * <p>
     * The maximum number of items to fetch for this dimension group.
     * </p>
     * 
     * @param limit
     *        The maximum number of items to fetch for this dimension group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DimensionGroup withLimit(Integer limit) {
        setLimit(limit);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getGroup() != null)
            sb.append("Group: ").append(getGroup()).append(",");
        if (getDimensions() != null)
            sb.append("Dimensions: ").append(getDimensions()).append(",");
        if (getLimit() != null)
            sb.append("Limit: ").append(getLimit());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DimensionGroup == false)
            return false;
        DimensionGroup other = (DimensionGroup) obj;
        if (other.getGroup() == null ^ this.getGroup() == null)
            return false;
        if (other.getGroup() != null && other.getGroup().equals(this.getGroup()) == false)
            return false;
        if (other.getDimensions() == null ^ this.getDimensions() == null)
            return false;
        if (other.getDimensions() != null && other.getDimensions().equals(this.getDimensions()) == false)
            return false;
        if (other.getLimit() == null ^ this.getLimit() == null)
            return false;
        if (other.getLimit() != null && other.getLimit().equals(this.getLimit()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getGroup() == null) ? 0 : getGroup().hashCode());
        hashCode = prime * hashCode + ((getDimensions() == null) ? 0 : getDimensions().hashCode());
        hashCode = prime * hashCode + ((getLimit() == null) ? 0 : getLimit().hashCode());
        return hashCode;
    }

    @Override
    public DimensionGroup clone() {
        try {
            return (DimensionGroup) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.pi.model.transform.DimensionGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
