/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.medialive;

import javax.annotation.Generated;

import com.amazonaws.services.medialive.model.*;
import com.amazonaws.*;
import com.amazonaws.services.medialive.waiters.AWSMediaLiveWaiters;

/**
 * Abstract implementation of {@code AWSMediaLive}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSMediaLive implements AWSMediaLive {

    protected AbstractAWSMediaLive() {
    }

    @Override
    public AcceptInputDeviceTransferResult acceptInputDeviceTransfer(AcceptInputDeviceTransferRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDeleteResult batchDelete(BatchDeleteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchStartResult batchStart(BatchStartRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchStopResult batchStop(BatchStopRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUpdateScheduleResult batchUpdateSchedule(BatchUpdateScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelInputDeviceTransferResult cancelInputDeviceTransfer(CancelInputDeviceTransferRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ClaimDeviceResult claimDevice(ClaimDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateChannelResult createChannel(CreateChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateInputResult createInput(CreateInputRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateInputSecurityGroupResult createInputSecurityGroup(CreateInputSecurityGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMultiplexResult createMultiplex(CreateMultiplexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMultiplexProgramResult createMultiplexProgram(CreateMultiplexProgramRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePartnerInputResult createPartnerInput(CreatePartnerInputRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTagsResult createTags(CreateTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelResult deleteChannel(DeleteChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInputResult deleteInput(DeleteInputRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInputSecurityGroupResult deleteInputSecurityGroup(DeleteInputSecurityGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMultiplexResult deleteMultiplex(DeleteMultiplexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMultiplexProgramResult deleteMultiplexProgram(DeleteMultiplexProgramRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteReservationResult deleteReservation(DeleteReservationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteScheduleResult deleteSchedule(DeleteScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTagsResult deleteTags(DeleteTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelResult describeChannel(DescribeChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInputResult describeInput(DescribeInputRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInputDeviceResult describeInputDevice(DescribeInputDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInputDeviceThumbnailResult describeInputDeviceThumbnail(DescribeInputDeviceThumbnailRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInputSecurityGroupResult describeInputSecurityGroup(DescribeInputSecurityGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMultiplexResult describeMultiplex(DescribeMultiplexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMultiplexProgramResult describeMultiplexProgram(DescribeMultiplexProgramRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeOfferingResult describeOffering(DescribeOfferingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeReservationResult describeReservation(DescribeReservationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeScheduleResult describeSchedule(DescribeScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelsResult listChannels(ListChannelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInputDeviceTransfersResult listInputDeviceTransfers(ListInputDeviceTransfersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInputDevicesResult listInputDevices(ListInputDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInputSecurityGroupsResult listInputSecurityGroups(ListInputSecurityGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInputsResult listInputs(ListInputsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMultiplexProgramsResult listMultiplexPrograms(ListMultiplexProgramsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMultiplexesResult listMultiplexes(ListMultiplexesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListOfferingsResult listOfferings(ListOfferingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListReservationsResult listReservations(ListReservationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PurchaseOfferingResult purchaseOffering(PurchaseOfferingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RebootInputDeviceResult rebootInputDevice(RebootInputDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RejectInputDeviceTransferResult rejectInputDeviceTransfer(RejectInputDeviceTransferRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartChannelResult startChannel(StartChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartInputDeviceMaintenanceWindowResult startInputDeviceMaintenanceWindow(StartInputDeviceMaintenanceWindowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMultiplexResult startMultiplex(StartMultiplexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopChannelResult stopChannel(StopChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopMultiplexResult stopMultiplex(StopMultiplexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TransferInputDeviceResult transferInputDevice(TransferInputDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChannelResult updateChannel(UpdateChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChannelClassResult updateChannelClass(UpdateChannelClassRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateInputResult updateInput(UpdateInputRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateInputDeviceResult updateInputDevice(UpdateInputDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateInputSecurityGroupResult updateInputSecurityGroup(UpdateInputSecurityGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMultiplexResult updateMultiplex(UpdateMultiplexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMultiplexProgramResult updateMultiplexProgram(UpdateMultiplexProgramRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateReservationResult updateReservation(UpdateReservationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AWSMediaLiveWaiters waiters() {
        throw new java.lang.UnsupportedOperationException();
    }

}
