/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lakeformation.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnitResults" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetWorkUnitResultsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The ID of the plan query operation for which to get results.
     * </p>
     */
    private String queryId;
    /**
     * <p>
     * The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to
     * <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of
     * <code>GetWorkUnits</code>.
     * </p>
     */
    private Long workUnitId;
    /**
     * <p>
     * A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.
     * </p>
     */
    private String workUnitToken;

    /**
     * <p>
     * The ID of the plan query operation for which to get results.
     * </p>
     * 
     * @param queryId
     *        The ID of the plan query operation for which to get results.
     */

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    /**
     * <p>
     * The ID of the plan query operation for which to get results.
     * </p>
     * 
     * @return The ID of the plan query operation for which to get results.
     */

    public String getQueryId() {
        return this.queryId;
    }

    /**
     * <p>
     * The ID of the plan query operation for which to get results.
     * </p>
     * 
     * @param queryId
     *        The ID of the plan query operation for which to get results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetWorkUnitResultsRequest withQueryId(String queryId) {
        setQueryId(queryId);
        return this;
    }

    /**
     * <p>
     * The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to
     * <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of
     * <code>GetWorkUnits</code>.
     * </p>
     * 
     * @param workUnitId
     *        The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to
     *        <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of
     *        <code>GetWorkUnits</code>.
     */

    public void setWorkUnitId(Long workUnitId) {
        this.workUnitId = workUnitId;
    }

    /**
     * <p>
     * The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to
     * <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of
     * <code>GetWorkUnits</code>.
     * </p>
     * 
     * @return The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to
     *         <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of
     *         <code>GetWorkUnits</code>.
     */

    public Long getWorkUnitId() {
        return this.workUnitId;
    }

    /**
     * <p>
     * The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to
     * <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of
     * <code>GetWorkUnits</code>.
     * </p>
     * 
     * @param workUnitId
     *        The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to
     *        <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of
     *        <code>GetWorkUnits</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetWorkUnitResultsRequest withWorkUnitId(Long workUnitId) {
        setWorkUnitId(workUnitId);
        return this;
    }

    /**
     * <p>
     * A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.
     * </p>
     * 
     * @param workUnitToken
     *        A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.
     */

    public void setWorkUnitToken(String workUnitToken) {
        this.workUnitToken = workUnitToken;
    }

    /**
     * <p>
     * A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.
     * </p>
     * 
     * @return A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.
     */

    public String getWorkUnitToken() {
        return this.workUnitToken;
    }

    /**
     * <p>
     * A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.
     * </p>
     * 
     * @param workUnitToken
     *        A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetWorkUnitResultsRequest withWorkUnitToken(String workUnitToken) {
        setWorkUnitToken(workUnitToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getQueryId() != null)
            sb.append("QueryId: ").append(getQueryId()).append(",");
        if (getWorkUnitId() != null)
            sb.append("WorkUnitId: ").append(getWorkUnitId()).append(",");
        if (getWorkUnitToken() != null)
            sb.append("WorkUnitToken: ").append("***Sensitive Data Redacted***");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetWorkUnitResultsRequest == false)
            return false;
        GetWorkUnitResultsRequest other = (GetWorkUnitResultsRequest) obj;
        if (other.getQueryId() == null ^ this.getQueryId() == null)
            return false;
        if (other.getQueryId() != null && other.getQueryId().equals(this.getQueryId()) == false)
            return false;
        if (other.getWorkUnitId() == null ^ this.getWorkUnitId() == null)
            return false;
        if (other.getWorkUnitId() != null && other.getWorkUnitId().equals(this.getWorkUnitId()) == false)
            return false;
        if (other.getWorkUnitToken() == null ^ this.getWorkUnitToken() == null)
            return false;
        if (other.getWorkUnitToken() != null && other.getWorkUnitToken().equals(this.getWorkUnitToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getQueryId() == null) ? 0 : getQueryId().hashCode());
        hashCode = prime * hashCode + ((getWorkUnitId() == null) ? 0 : getWorkUnitId().hashCode());
        hashCode = prime * hashCode + ((getWorkUnitToken() == null) ? 0 : getWorkUnitToken().hashCode());
        return hashCode;
    }

    @Override
    public GetWorkUnitResultsRequest clone() {
        return (GetWorkUnitResultsRequest) super.clone();
    }

}
