/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceResult;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteInstanceEventWindowResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The state of the event window.
     * </p>
     */
    private InstanceEventWindowStateChange instanceEventWindowState;

    /**
     * <p>
     * The state of the event window.
     * </p>
     * 
     * @param instanceEventWindowState
     *        The state of the event window.
     */

    public void setInstanceEventWindowState(InstanceEventWindowStateChange instanceEventWindowState) {
        this.instanceEventWindowState = instanceEventWindowState;
    }

    /**
     * <p>
     * The state of the event window.
     * </p>
     * 
     * @return The state of the event window.
     */

    public InstanceEventWindowStateChange getInstanceEventWindowState() {
        return this.instanceEventWindowState;
    }

    /**
     * <p>
     * The state of the event window.
     * </p>
     * 
     * @param instanceEventWindowState
     *        The state of the event window.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteInstanceEventWindowResult withInstanceEventWindowState(InstanceEventWindowStateChange instanceEventWindowState) {
        setInstanceEventWindowState(instanceEventWindowState);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getInstanceEventWindowState() != null)
            sb.append("InstanceEventWindowState: ").append(getInstanceEventWindowState());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteInstanceEventWindowResult == false)
            return false;
        DeleteInstanceEventWindowResult other = (DeleteInstanceEventWindowResult) obj;
        if (other.getInstanceEventWindowState() == null ^ this.getInstanceEventWindowState() == null)
            return false;
        if (other.getInstanceEventWindowState() != null && other.getInstanceEventWindowState().equals(this.getInstanceEventWindowState()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getInstanceEventWindowState() == null) ? 0 : getInstanceEventWindowState().hashCode());
        return hashCode;
    }

    @Override
    public DeleteInstanceEventWindowResult clone() {
        try {
            return (DeleteInstanceEventWindowResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }
}
