/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ebs.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/ListSnapshotBlocks" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListSnapshotBlocksRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The ID of the snapshot from which to get block indexes and block tokens.
     * </p>
     */
    private String snapshotId;
    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * <p>
     * If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The maximum number of blocks to be returned by the request.
     * </p>
     * <p>
     * Even if additional blocks can be retrieved from the snapshot, the request can return less blocks than
     * <b>MaxResults</b> or an empty array of blocks.
     * </p>
     * <p>
     * To retrieve the next set of blocks from the snapshot, make another request with the returned <b>NextToken</b>
     * value. The value of <b>NextToken</b> is <code>null</code> when there are no more blocks to return.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * The block index from which the list should start. The list in the response will start from this block index or
     * the next valid block index in the snapshot.
     * </p>
     * <p>
     * If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.
     * </p>
     */
    private Integer startingBlockIndex;

    /**
     * <p>
     * The ID of the snapshot from which to get block indexes and block tokens.
     * </p>
     * 
     * @param snapshotId
     *        The ID of the snapshot from which to get block indexes and block tokens.
     */

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    /**
     * <p>
     * The ID of the snapshot from which to get block indexes and block tokens.
     * </p>
     * 
     * @return The ID of the snapshot from which to get block indexes and block tokens.
     */

    public String getSnapshotId() {
        return this.snapshotId;
    }

    /**
     * <p>
     * The ID of the snapshot from which to get block indexes and block tokens.
     * </p>
     * 
     * @param snapshotId
     *        The ID of the snapshot from which to get block indexes and block tokens.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSnapshotBlocksRequest withSnapshotId(String snapshotId) {
        setSnapshotId(snapshotId);
        return this;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * <p>
     * If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.
     * </p>
     * 
     * @param nextToken
     *        The token to request the next page of results.</p>
     *        <p>
     *        If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * <p>
     * If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.
     * </p>
     * 
     * @return The token to request the next page of results.</p>
     *         <p>
     *         If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * <p>
     * If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.
     * </p>
     * 
     * @param nextToken
     *        The token to request the next page of results.</p>
     *        <p>
     *        If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSnapshotBlocksRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The maximum number of blocks to be returned by the request.
     * </p>
     * <p>
     * Even if additional blocks can be retrieved from the snapshot, the request can return less blocks than
     * <b>MaxResults</b> or an empty array of blocks.
     * </p>
     * <p>
     * To retrieve the next set of blocks from the snapshot, make another request with the returned <b>NextToken</b>
     * value. The value of <b>NextToken</b> is <code>null</code> when there are no more blocks to return.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of blocks to be returned by the request.</p>
     *        <p>
     *        Even if additional blocks can be retrieved from the snapshot, the request can return less blocks than
     *        <b>MaxResults</b> or an empty array of blocks.
     *        </p>
     *        <p>
     *        To retrieve the next set of blocks from the snapshot, make another request with the returned
     *        <b>NextToken</b> value. The value of <b>NextToken</b> is <code>null</code> when there are no more blocks
     *        to return.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of blocks to be returned by the request.
     * </p>
     * <p>
     * Even if additional blocks can be retrieved from the snapshot, the request can return less blocks than
     * <b>MaxResults</b> or an empty array of blocks.
     * </p>
     * <p>
     * To retrieve the next set of blocks from the snapshot, make another request with the returned <b>NextToken</b>
     * value. The value of <b>NextToken</b> is <code>null</code> when there are no more blocks to return.
     * </p>
     * 
     * @return The maximum number of blocks to be returned by the request.</p>
     *         <p>
     *         Even if additional blocks can be retrieved from the snapshot, the request can return less blocks than
     *         <b>MaxResults</b> or an empty array of blocks.
     *         </p>
     *         <p>
     *         To retrieve the next set of blocks from the snapshot, make another request with the returned
     *         <b>NextToken</b> value. The value of <b>NextToken</b> is <code>null</code> when there are no more blocks
     *         to return.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of blocks to be returned by the request.
     * </p>
     * <p>
     * Even if additional blocks can be retrieved from the snapshot, the request can return less blocks than
     * <b>MaxResults</b> or an empty array of blocks.
     * </p>
     * <p>
     * To retrieve the next set of blocks from the snapshot, make another request with the returned <b>NextToken</b>
     * value. The value of <b>NextToken</b> is <code>null</code> when there are no more blocks to return.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of blocks to be returned by the request.</p>
     *        <p>
     *        Even if additional blocks can be retrieved from the snapshot, the request can return less blocks than
     *        <b>MaxResults</b> or an empty array of blocks.
     *        </p>
     *        <p>
     *        To retrieve the next set of blocks from the snapshot, make another request with the returned
     *        <b>NextToken</b> value. The value of <b>NextToken</b> is <code>null</code> when there are no more blocks
     *        to return.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSnapshotBlocksRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * The block index from which the list should start. The list in the response will start from this block index or
     * the next valid block index in the snapshot.
     * </p>
     * <p>
     * If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.
     * </p>
     * 
     * @param startingBlockIndex
     *        The block index from which the list should start. The list in the response will start from this block
     *        index or the next valid block index in the snapshot.</p>
     *        <p>
     *        If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.
     */

    public void setStartingBlockIndex(Integer startingBlockIndex) {
        this.startingBlockIndex = startingBlockIndex;
    }

    /**
     * <p>
     * The block index from which the list should start. The list in the response will start from this block index or
     * the next valid block index in the snapshot.
     * </p>
     * <p>
     * If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.
     * </p>
     * 
     * @return The block index from which the list should start. The list in the response will start from this block
     *         index or the next valid block index in the snapshot.</p>
     *         <p>
     *         If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.
     */

    public Integer getStartingBlockIndex() {
        return this.startingBlockIndex;
    }

    /**
     * <p>
     * The block index from which the list should start. The list in the response will start from this block index or
     * the next valid block index in the snapshot.
     * </p>
     * <p>
     * If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.
     * </p>
     * 
     * @param startingBlockIndex
     *        The block index from which the list should start. The list in the response will start from this block
     *        index or the next valid block index in the snapshot.</p>
     *        <p>
     *        If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSnapshotBlocksRequest withStartingBlockIndex(Integer startingBlockIndex) {
        setStartingBlockIndex(startingBlockIndex);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSnapshotId() != null)
            sb.append("SnapshotId: ").append(getSnapshotId()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getStartingBlockIndex() != null)
            sb.append("StartingBlockIndex: ").append(getStartingBlockIndex());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListSnapshotBlocksRequest == false)
            return false;
        ListSnapshotBlocksRequest other = (ListSnapshotBlocksRequest) obj;
        if (other.getSnapshotId() == null ^ this.getSnapshotId() == null)
            return false;
        if (other.getSnapshotId() != null && other.getSnapshotId().equals(this.getSnapshotId()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getStartingBlockIndex() == null ^ this.getStartingBlockIndex() == null)
            return false;
        if (other.getStartingBlockIndex() != null && other.getStartingBlockIndex().equals(this.getStartingBlockIndex()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSnapshotId() == null) ? 0 : getSnapshotId().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getStartingBlockIndex() == null) ? 0 : getStartingBlockIndex().hashCode());
        return hashCode;
    }

    @Override
    public ListSnapshotBlocksRequest clone() {
        return (ListSnapshotBlocksRequest) super.clone();
    }

}
