/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codegurureviewer.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.codegurureviewer.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * MetricsSummaryMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class MetricsSummaryMarshaller {

    private static final MarshallingInfo<Long> METEREDLINESOFCODECOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MeteredLinesOfCodeCount").build();
    private static final MarshallingInfo<Long> SUPPRESSEDLINESOFCODECOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SuppressedLinesOfCodeCount").build();
    private static final MarshallingInfo<Long> FINDINGSCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("FindingsCount").build();

    private static final MetricsSummaryMarshaller instance = new MetricsSummaryMarshaller();

    public static MetricsSummaryMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(MetricsSummary metricsSummary, ProtocolMarshaller protocolMarshaller) {

        if (metricsSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(metricsSummary.getMeteredLinesOfCodeCount(), METEREDLINESOFCODECOUNT_BINDING);
            protocolMarshaller.marshall(metricsSummary.getSuppressedLinesOfCodeCount(), SUPPRESSEDLINESOFCODECOUNT_BINDING);
            protocolMarshaller.marshall(metricsSummary.getFindingsCount(), FINDINGSCOUNT_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
