/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudfront.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateRealtimeLogConfig" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateRealtimeLogConfigResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A real-time log configuration.
     * </p>
     */
    private RealtimeLogConfig realtimeLogConfig;

    /**
     * <p>
     * A real-time log configuration.
     * </p>
     * 
     * @param realtimeLogConfig
     *        A real-time log configuration.
     */

    public void setRealtimeLogConfig(RealtimeLogConfig realtimeLogConfig) {
        this.realtimeLogConfig = realtimeLogConfig;
    }

    /**
     * <p>
     * A real-time log configuration.
     * </p>
     * 
     * @return A real-time log configuration.
     */

    public RealtimeLogConfig getRealtimeLogConfig() {
        return this.realtimeLogConfig;
    }

    /**
     * <p>
     * A real-time log configuration.
     * </p>
     * 
     * @param realtimeLogConfig
     *        A real-time log configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRealtimeLogConfigResult withRealtimeLogConfig(RealtimeLogConfig realtimeLogConfig) {
        setRealtimeLogConfig(realtimeLogConfig);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRealtimeLogConfig() != null)
            sb.append("RealtimeLogConfig: ").append(getRealtimeLogConfig());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateRealtimeLogConfigResult == false)
            return false;
        UpdateRealtimeLogConfigResult other = (UpdateRealtimeLogConfigResult) obj;
        if (other.getRealtimeLogConfig() == null ^ this.getRealtimeLogConfig() == null)
            return false;
        if (other.getRealtimeLogConfig() != null && other.getRealtimeLogConfig().equals(this.getRealtimeLogConfig()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRealtimeLogConfig() == null) ? 0 : getRealtimeLogConfig().hashCode());
        return hashCode;
    }

    @Override
    public UpdateRealtimeLogConfigResult clone() {
        try {
            return (UpdateRealtimeLogConfigResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
