/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.xray.model.Http;

@SdkInternalApi
public class HttpMarshaller {
    private static final MarshallingInfo<String> HTTPURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HttpURL").build();
    private static final MarshallingInfo<Integer> HTTPSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HttpStatus").build();
    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HttpMethod").build();
    private static final MarshallingInfo<String> USERAGENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserAgent").build();
    private static final MarshallingInfo<String> CLIENTIP_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientIp").build();
    private static final HttpMarshaller instance = new HttpMarshaller();

    public static HttpMarshaller getInstance() {
        return instance;
    }

    public void marshall(Http http, ProtocolMarshaller protocolMarshaller) {
        if (http == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(http.getHttpURL(), HTTPURL_BINDING);
            protocolMarshaller.marshall(http.getHttpStatus(), HTTPSTATUS_BINDING);
            protocolMarshaller.marshall(http.getHttpMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall(http.getUserAgent(), USERAGENT_BINDING);
            protocolMarshaller.marshall(http.getClientIp(), CLIENTIP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

