/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.states;

import com.amazonaws.services.stepfunctions.builder.states.InputOutputPathBuilder;
import com.amazonaws.services.stepfunctions.builder.states.PathContainer;
import com.amazonaws.services.stepfunctions.builder.states.StateVisitor;
import com.amazonaws.services.stepfunctions.builder.states.Transition;
import com.amazonaws.services.stepfunctions.builder.states.TransitionState;
import com.amazonaws.services.stepfunctions.builder.states.TransitionStateBuilder;
import com.amazonaws.services.stepfunctions.builder.states.WaitFor;
import com.amazonaws.services.stepfunctions.builder.states.WaitForSeconds;
import com.amazonaws.services.stepfunctions.builder.states.WaitForSecondsPath;
import com.amazonaws.services.stepfunctions.builder.states.WaitForTimestamp;
import com.amazonaws.services.stepfunctions.builder.states.WaitForTimestampPath;
import com.amazonaws.thirdparty.jackson.annotation.JsonCreator;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import com.amazonaws.thirdparty.jackson.annotation.JsonUnwrapped;
import java.util.Date;

public final class WaitState
extends TransitionState {
    @JsonProperty(value="Comment")
    private final String comment;
    @JsonUnwrapped
    private final WaitFor waitFor;
    @JsonUnwrapped
    private final PathContainer pathContainer;
    @JsonUnwrapped
    private final Transition transition;

    @JsonCreator
    private WaitState(Builder builder) {
        this.comment = builder.comment;
        this.waitFor = (WaitFor)builder.waitFor.build();
        this.pathContainer = builder.pathContainer.build();
        this.transition = (Transition)builder.transition.build();
    }

    @Override
    public String getType() {
        return "Wait";
    }

    public String getComment() {
        return this.comment;
    }

    public WaitFor getWaitFor() {
        return this.waitFor;
    }

    @JsonIgnore
    public String getInputPath() {
        return this.pathContainer.getInputPath();
    }

    @JsonIgnore
    public String getOutputPath() {
        return this.pathContainer.getOutputPath();
    }

    @Override
    public Transition getTransition() {
        return this.transition;
    }

    @Override
    public <T> T accept(StateVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends TransitionStateBuilder
    implements InputOutputPathBuilder<Builder> {
        @JsonProperty(value="Comment")
        private String comment;
        private WaitFor.Builder waitFor = WaitFor.NULL_BUILDER;
        private final PathContainer.Builder pathContainer = PathContainer.builder();
        @JsonProperty
        private Transition.Builder transition = Transition.NULL_BUILDER;

        private Builder() {
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @JsonProperty(value="Seconds")
        private Builder seconds(Integer seconds) {
            return this.waitFor(WaitForSeconds.builder().seconds(seconds));
        }

        @JsonProperty(value="Timestamp")
        private Builder timestamp(Date timestamp) {
            return this.waitFor(WaitForTimestamp.builder().timestamp(timestamp));
        }

        @JsonProperty(value="TimestampPath")
        private Builder timestampPath(String timestampPath) {
            return this.waitFor(WaitForTimestampPath.builder().timestampPath(timestampPath));
        }

        @JsonProperty(value="SecondsPath")
        private Builder secondsPath(String secondsPath) {
            return this.waitFor(WaitForSecondsPath.builder().secondsPath(secondsPath));
        }

        public Builder waitFor(WaitFor.Builder waitFor) {
            this.waitFor = waitFor;
            return this;
        }

        @Override
        public Builder inputPath(String inputPath) {
            this.pathContainer.inputPath(inputPath);
            return this;
        }

        @Override
        public Builder outputPath(String outputPath) {
            this.pathContainer.outputPath(outputPath);
            return this;
        }

        @Override
        public Builder transition(Transition.Builder transition) {
            this.transition = transition;
            return this;
        }

        @Override
        public WaitState build() {
            return new WaitState(this);
        }
    }
}

